/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.console;

import java.util.Collections;
import java.util.List;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsole;

public class IvyDEMessageLogger
implements MessageLogger {
    private IvyConsole console;
    private int logLevel;

    public IvyDEMessageLogger(IvyConsole console) {
        this.console = console;
        this.logLevel = IvyPlugin.getPreferenceStoreHelper().getIvyConsoleIvyDELogLevel();
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        IvyPlugin.getPreferenceStoreHelper().setIvyConsoleIvyDELogLevel(logLevel);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void log(String msg, int level) {
        if (level <= this.logLevel) {
            this.console.doAppendLine(level, "[IvyDE] " + msg);
        }
    }

    public void rawlog(String msg, int level) {
        this.log(msg, level);
    }

    public void debug(String msg) {
        this.log(msg, 4);
    }

    public void verbose(String msg) {
        this.log(msg, 3);
    }

    public void deprecated(String msg) {
        this.log("DEPRECATED: " + msg, 1);
    }

    public void info(String msg) {
        this.log(msg, 2);
    }

    public void rawinfo(String msg) {
        this.rawlog(msg, 2);
    }

    public void warn(String msg) {
        this.log(msg, 1);
    }

    public void error(String msg) {
        this.log(msg, 0);
    }

    public void sumupProblems() {
    }

    public void clearProblems() {
    }

    public List getProblems() {
        return Collections.emptyList();
    }

    public List getErrors() {
        return Collections.emptyList();
    }

    public List getWarns() {
        return Collections.emptyList();
    }

    public void progress() {
    }

    public void endProgress() {
    }

    public void endProgress(String msg) {
    }

    public boolean isShowProgress() {
        return false;
    }

    public void setShowProgress(boolean progress) {
    }
}

