/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.preferences;

import org.apache.ivyde.eclipse.cp.AdvancedSetup;
import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.eclipse.cp.MappingSetup;
import org.apache.ivyde.eclipse.cp.RetrieveSetup;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class IvyDEPreferenceStoreHelper {
    private final IPreferenceStore prefStore;

    public IvyDEPreferenceStoreHelper(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
    }

    public String getIvyOrg() {
        return this.prefStore.getString("ivy_org");
    }

    public void setIvyOrg(String org) {
        this.prefStore.setValue("ivy_org", org);
    }

    public String getIvyOrgUrl() {
        return this.prefStore.getString("ivy_org_url");
    }

    public void setIvyOrgUrl(String url) {
        this.prefStore.setValue("ivy_org_url", url);
    }

    public SettingsSetup getSettingsSetup() {
        SettingsSetup setup = new SettingsSetup();
        setup.setIvySettingsPath(this.prefStore.getString("ivy_conf_path"));
        setup.setLoadSettingsOnDemand(this.prefStore.getBoolean("loadSettingsOnDemand"));
        setup.setIvyUserDir(this.prefStore.getString("ivuUserDir"));
        setup.setPropertyFiles(IvyClasspathUtil.split(this.prefStore.getString("propertyFiles")));
        return setup;
    }

    public void setSettingsSetup(SettingsSetup setup) {
        this.prefStore.setValue("ivy_conf_path", setup.getRawIvySettingsPath());
        this.prefStore.setValue("propertyFiles", IvyClasspathUtil.concat(setup.getRawPropertyFiles()));
        this.prefStore.setValue("ivuUserDir", setup.getRawIvyUserDir());
        this.prefStore.setValue("loadSettingsOnDemand", setup.isLoadSettingsOnDemand());
    }

    public ClasspathSetup getClasspathSetup() {
        ClasspathSetup setup = new ClasspathSetup();
        setup.setResolveInWorkspace(this.prefStore.getBoolean("resolveInWorkspace"));
        setup.setTransitiveResolve(this.prefStore.getBoolean("transitiveResolve"));
        setup.setReadOSGiMetadata(this.prefStore.getBoolean("readOSGIMetadata"));
        setup.setAcceptedTypes(IvyClasspathUtil.split(this.prefStore.getString("acceptedTypes")));
        setup.setAlphaOrder(this.prefStore.getBoolean("order.alphabetical"));
        setup.setRetrievedClasspath(this.prefStore.getBoolean("retrievedClasspath"));
        RetrieveSetup retrieveSetup = new RetrieveSetup();
        retrieveSetup.setRetrievePattern(this.prefStore.getString("retrievedClasspath.pattern"));
        retrieveSetup.setRetrieveSync(this.prefStore.getBoolean("retrievedClasspath.sync"));
        retrieveSetup.setRetrieveTypes(this.prefStore.getString("retrievedClasspath.types"));
        setup.setRetrieveSetup(retrieveSetup);
        return setup;
    }

    public void setClasspathSetup(ClasspathSetup setup) {
        this.prefStore.setValue("resolveInWorkspace", setup.isResolveInWorkspace());
        this.prefStore.setValue("transitiveResolve", setup.isTransitiveResolve());
        this.prefStore.setValue("readOSGIMetadata", setup.isReadOSGiMetadata());
        this.prefStore.setValue("acceptedTypes", IvyClasspathUtil.concat(setup.getAcceptedTypes()));
        this.prefStore.setValue("order.alphabetical", setup.isAlphaOrder());
        this.prefStore.setValue("retrievedClasspath", setup.isRetrievedClasspath());
        RetrieveSetup retrieveSetup = setup.getRetrieveSetup();
        this.prefStore.setValue("retrievedClasspath.pattern", retrieveSetup.getRetrievePattern());
        this.prefStore.setValue("retrievedClasspath.sync", retrieveSetup.isRetrieveSync());
        this.prefStore.setValue("retrievedClasspath.types", retrieveSetup.getRetrieveTypes());
    }

    public MappingSetup getMappingSetup() {
        MappingSetup setup = new MappingSetup();
        setup.setSourceTypes(IvyClasspathUtil.split(this.prefStore.getString("sourceTypes")));
        setup.setJavadocTypes(IvyClasspathUtil.split(this.prefStore.getString("javadocTypes")));
        setup.setSourceSuffixes(IvyClasspathUtil.split(this.prefStore.getString("sourceSuffixes")));
        setup.setJavadocSuffixes(IvyClasspathUtil.split(this.prefStore.getString("javadocSuffixes")));
        setup.setMapIfOnlyOneSource(this.prefStore.getBoolean("mapIfOnlyOneSource"));
        setup.setMapIfOnlyOneJavadoc(this.prefStore.getBoolean("mapIfOnlyOneJavadoc"));
        return setup;
    }

    public void setMappingSetup(MappingSetup setup) {
        this.prefStore.setValue("sourceTypes", IvyClasspathUtil.concat(setup.getSourceTypes()));
        this.prefStore.setValue("javadocTypes", IvyClasspathUtil.concat(setup.getJavadocTypes()));
        this.prefStore.setValue("sourceSuffixes", IvyClasspathUtil.concat(setup.getSourceSuffixes()));
        this.prefStore.setValue("javadocSuffixes", IvyClasspathUtil.concat(setup.getJavadocSuffixes()));
        this.prefStore.setValue("mapIfOnlyOneSource", setup.isMapIfOnlyOneSource());
        this.prefStore.setValue("mapIfOnlyOneJavadoc", setup.isMapIfOnlyOneJavadoc());
    }

    public AdvancedSetup getAdvancedSetup() {
        AdvancedSetup setup = new AdvancedSetup();
        setup.setResolveBeforeLaunch(this.prefStore.getBoolean("resolveBeforeLaunch"));
        setup.setUseExtendedResolveId(this.prefStore.getBoolean("useExtendedResolveId"));
        return setup;
    }

    public void setAdvancedSetup(AdvancedSetup setup) {
        this.prefStore.setValue("resolveBeforeLaunch", setup.isResolveBeforeLaunch());
        this.prefStore.setValue("useExtendedResolveId", setup.isUseExtendedResolveId());
    }

    public String getOrganization() {
        return this.prefStore.getString("ivy_org");
    }

    public void setOrganization(String org) {
        this.prefStore.setValue("ivy_org", org);
    }

    public String getOrganizationUrl() {
        return this.prefStore.getString("ivy_org_url");
    }

    public void setOrganizationUrl(String url) {
        this.prefStore.setValue("ivy_org_url", url);
    }

    public int getResolveOnStartup() {
        return this.prefStore.getInt("resolveOnStartup");
    }

    public void setResolveOnStartup(int resolveOnStartup) {
        this.prefStore.setValue("resolveOnStartup", resolveOnStartup);
    }

    public boolean getAutoResolveOnClose() {
        return this.prefStore.getBoolean("autoResolve.close");
    }

    public void setAutoResolveOnClose(boolean autoResolveOnOpen) {
        this.prefStore.setValue("autoResolve.close", autoResolveOnOpen);
    }

    public boolean getAutoResolveOnOpen() {
        return this.prefStore.getBoolean("autoResolve.open");
    }

    public void setAutoResolveOnOpen(boolean autoResolveOnOpen) {
        this.prefStore.setValue("autoResolve.open", autoResolveOnOpen);
    }

    public boolean getAutoResolveOnChange() {
        return this.prefStore.getBoolean("autoResolve.change");
    }

    public void setAutoResolveOnChange(boolean autoResolveChange) {
        this.prefStore.setValue("autoResolve.change", autoResolveChange);
    }

    public int getIvyConsoleLogLevel() {
        return this.prefStore.getInt("ivyConsole.logLevel");
    }

    public void setIvyConsoleLogLevel(int logLevel) {
        this.prefStore.setValue("ivyConsole.logLevel", logLevel);
    }

    public int getIvyConsoleIvyDELogLevel() {
        return this.prefStore.getInt("ivyConsole.ivyDELogLevel");
    }

    public void setIvyConsoleIvyDELogLevel(int ivyDElogLevel) {
        this.prefStore.setValue("ivyConsole.ivyDELogLevel", ivyDElogLevel);
    }

    public boolean isOpenIvyConsoleOnStartup() {
        return this.prefStore.getBoolean("ivyConsole.openOnStartup");
    }

    public void setOpenIvyConsoleOnStartup(boolean openOnStartup) {
        this.prefStore.setValue("ivyConsole.openOnStartup", openOnStartup);
    }

    public boolean getIgnoreBranchOnWorkspaceProjects() {
        return this.prefStore.getBoolean("workspaceResolver.ignoreBranch");
    }

    public void setIgnoreBranchOnWorkspaceProjects(boolean ignoreBranchOnWorkspaceProjects) {
        this.prefStore.setValue("workspaceResolver.ignoreBranch", ignoreBranchOnWorkspaceProjects);
    }

    public boolean getIgnoreVersionOnWorkspaceProjects() {
        return this.prefStore.getBoolean("workspaceResolver.ignoreVersion");
    }

    public void setIgnoreVersionOnWorkspaceProjects(boolean ignoreVersionOnWorkspaceProjects) {
        this.prefStore.setValue("workspaceResolver.ignoreVersion", ignoreVersionOnWorkspaceProjects);
    }

    public RGB getEditorColorXmlComment() {
        return PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"editor.color.xmlComment");
    }

    public void setEditorColorXmlComment(RGB color) {
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"editor.color.xmlComment", (RGB)color);
    }

    public RGB getEditorColorProcInst() {
        return PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"editor.color.procInstr");
    }

    public void setEditorColorProcInst(RGB color) {
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"editor.color.procInstr", (RGB)color);
    }

    public RGB getEditorColorString() {
        return PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"editor.color.string");
    }

    public void setEditorColorString(RGB color) {
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"editor.color.string", (RGB)color);
    }

    public RGB getEditorColorDefault() {
        return PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"editor.color.default");
    }

    public void setEditorColorDefault(RGB color) {
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"editor.color.default", (RGB)color);
    }

    public RGB getEditorColorTag() {
        return PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"editor.color.tag");
    }

    public void setEditorColorTag(RGB color) {
        PreferenceConverter.setValue((IPreferenceStore)this.prefStore, (String)"editor.color.tag", (RGB)color);
    }

    public boolean isOffline() {
        return this.prefStore.getBoolean("offline");
    }

    public void setOffline(boolean offline) {
        this.prefStore.setValue("offline", offline);
    }

    public boolean isErrorPopup() {
        return this.prefStore.getBoolean("error.popup");
    }

    public void setErrorPopup(boolean errorPopup) {
        this.prefStore.setValue("error.popup", errorPopup);
    }
}

