/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.preferences;

import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkspaceResolverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int HORIZ_INDENT = 40;

    public WorkspaceResolverPreferencePage() {
        super(1);
        this.setPreferenceStore(IvyPlugin.getDefault().getPreferenceStore());
        this.setDescription("");
    }

    public void createFieldEditors() {
        Composite fieldParent = this.getFieldEditorParent();
        BooleanFieldEditor autoResolveOnClose = new BooleanFieldEditor("autoResolve.close", "On project closing trigger resolve on dependent project", fieldParent){

            protected Label getLabelControl() {
                Label label = super.getLabelControl();
                label.setToolTipText("Will automatically resolve projects in the workspace after dependent project is closed");
                return label;
            }
        };
        this.addField((FieldEditor)autoResolveOnClose);
        BooleanFieldEditor autoResolveOnOpen = new BooleanFieldEditor("autoResolve.open", "On project opening trigger resolve on every other project", fieldParent){

            protected Label getLabelControl() {
                Label label = super.getLabelControl();
                label.setToolTipText("Will automatically resolve projects in the workspace and link open project where necessary");
                return label;
            }
        };
        this.addField((FieldEditor)autoResolveOnOpen);
        BooleanFieldEditor ignoreBranchOnWorkspaceProjects = new BooleanFieldEditor("workspaceResolver.ignoreBranch", "Ignore branch when resolving workspace projects", fieldParent){

            protected Label getLabelControl() {
                Label label = super.getLabelControl();
                label.setToolTipText("Will ignore the artifact branch when resolving against workspace projects");
                return label;
            }
        };
        this.addField((FieldEditor)ignoreBranchOnWorkspaceProjects);
        BooleanFieldEditor ignoreVersionOnWorkspaceProjects = new BooleanFieldEditor("workspaceResolver.ignoreVersion", "Ignore version when resolving workspace projects", fieldParent){

            protected Label getLabelControl() {
                Label label = super.getLabelControl();
                label.setToolTipText("Will ignore the artifact version when resolving against workspace projects");
                return label;
            }
        };
        this.addField((FieldEditor)ignoreVersionOnWorkspaceProjects);
        Label warning = new Label(fieldParent, 0);
        warning.setText("WARNING: you should ignore branch and/or revision only\nif you are sure that all the project revisions that are\nopen in your workspace can actually work together\n(be careful with branch management for instance)");
        GridData gridData = new GridData();
        gridData.horizontalIndent = 40;
        warning.setLayoutData((Object)gridData);
    }

    public void init(IWorkbench workbench) {
    }
}

