/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.workspaceresolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class WorkspaceResolver
extends AbstractResolver {
    public static final String ECLIPSE_PROJECT_TYPE = "eclipse-project";
    public static final String ECLIPSE_PROJECT_EXTENSION = "eclipse-project";
    public static final String CACHE_NAME = "__ivyde-workspace-resolver-cache";
    public static final String IVYDE_WORKSPACE_ARTIFACTS = "IvyDEWorkspaceArtifacts";
    public static final String IVYDE_WORKSPACE_ARTIFACT_REPORTS = "IvyDEWorkspaceArtifactReports";
    private IProject[] projects;
    private boolean ignoreBranchOnWorkspaceProjects;
    private boolean ignoreVersionOnWorkspaceProjects;

    public WorkspaceResolver(IProject project, IvySettings ivySettings) {
        String projectName = project == null ? "<null>" : project.getName();
        this.setName(String.valueOf(projectName) + "-ivyde-workspace-resolver");
        this.setSettings((ResolverSettings)ivySettings);
        this.setCache(CACHE_NAME);
        this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.ignoreBranchOnWorkspaceProjects = IvyPlugin.getPreferenceStoreHelper().getIgnoreBranchOnWorkspaceProjects();
        this.ignoreVersionOnWorkspaceProjects = IvyPlugin.getPreferenceStoreHelper().getIgnoreVersionOnWorkspaceProjects();
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        IvyContext context = IvyContext.getContext();
        Map workspaceArtifacts = (Map)context.get(IVYDE_WORKSPACE_ARTIFACTS);
        HashMap<Artifact, ArtifactDownloadReport> workspaceReports = null;
        if (workspaceArtifacts != null) {
            workspaceReports = new HashMap<Artifact, ArtifactDownloadReport>();
            context.set(IVYDE_WORKSPACE_ARTIFACT_REPORTS, workspaceReports);
        }
        DownloadReport dr = new DownloadReport();
        int i = 0;
        while (i < artifacts.length) {
            ArtifactDownloadReport adr = new ArtifactDownloadReport(artifacts[i]);
            dr.addArtifactReport(adr);
            if (artifacts[i].getType().equals("eclipse-project")) {
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(0L);
                Message.verbose((String)("\t[IN WORKSPACE] " + artifacts[i]));
            } else if (workspaceArtifacts != null && workspaceArtifacts.containsKey(artifacts[i])) {
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(0L);
                Artifact eclipseArtifact = (Artifact)workspaceArtifacts.get(artifacts[i]);
                ArtifactDownloadReport eclipseAdr = new ArtifactDownloadReport(eclipseArtifact);
                eclipseAdr.setDownloadStatus(DownloadStatus.NO);
                eclipseAdr.setSize(0L);
                workspaceReports.put(artifacts[i], eclipseAdr);
                Message.verbose((String)("\t[IN WORKSPACE] " + eclipseArtifact));
            } else {
                adr.setDownloadStatus(DownloadStatus.FAILED);
                Message.verbose((String)("\t[Eclipse Workspace resolver] cannot download non-project artifact: " + artifacts[i]));
            }
            ++i;
        }
        return dr;
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        String contextId;
        IvyContext context = IvyContext.getContext();
        DependencyDescriptor parentDD = (DependencyDescriptor)context.get(contextId = "ivyde.workspaceresolver." + this.getName() + "." + dd.getDependencyRevisionId().toString());
        if (parentDD != null && parentDD.getDependencyRevisionId().equals((Object)dd.getDependencyRevisionId())) {
            return null;
        }
        context.set(contextId, (Object)dd);
        ModuleRevisionId dependencyMrid = dd.getDependencyRevisionId();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        int i = 0;
        while (i < this.projects.length) {
            IProject p = this.projects[i];
            if (p.exists()) {
                List containers = IvyClasspathContainerHelper.getContainers(p);
                Iterator itContainer = containers.iterator();
                while (itContainer.hasNext()) {
                    ModuleRevisionId candidateMrid;
                    IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainer.next();
                    ModuleDescriptor md = ivycp.getState().getCachedModuleDescriptor();
                    if (md == null || !(candidateMrid = md.getModuleRevisionId()).getModuleId().equals((Object)dependencyMrid.getModuleId())) continue;
                    IvyDEMessage.verbose("Workspace resolver found potential matching project " + p.getName() + " with module " + candidateMrid + " for module " + dependencyMrid);
                    if (!this.ignoreBranchOnWorkspaceProjects) {
                        ModuleId mid = dependencyMrid.getModuleId();
                        String defaultBranch = this.getSettings().getDefaultBranch(mid);
                        String dependencyBranch = dependencyMrid.getBranch();
                        String candidateBranch = candidateMrid.getBranch();
                        if (dependencyBranch == null) {
                            dependencyBranch = defaultBranch;
                        }
                        if (candidateBranch == null) {
                            candidateBranch = defaultBranch;
                        }
                        if (dependencyBranch != candidateBranch) {
                            if (dependencyBranch == null || candidateBranch == null) {
                                IvyDEMessage.verbose("\t\trejected since branches doesn't match (one is set, the other isn't)");
                                continue;
                            }
                            if (!dependencyBranch.equals(candidateBranch)) {
                                IvyDEMessage.verbose("\t\trejected since branches doesn't match");
                                continue;
                            }
                        }
                    }
                    if (this.ignoreVersionOnWorkspaceProjects || md.getModuleRevisionId().getRevision().equals(Ivy.getWorkingRevision()) || versionMatcher.accept(dd.getDependencyRevisionId(), md)) {
                        if (this.ignoreVersionOnWorkspaceProjects) {
                            IvyDEMessage.verbose("\t\tmatched (version are ignored)");
                        } else {
                            IvyDEMessage.verbose("\t\tversion matched");
                        }
                        DefaultArtifact af = new DefaultArtifact(md.getModuleRevisionId(), md.getPublicationDate(), p.getFullPath().toString(), "eclipse-project", "eclipse-project");
                        DependencyArtifactDescriptor[] dArtifacts = dd.getAllDependencyArtifacts();
                        if (dArtifacts != null) {
                            IvyContext currentContext = IvyContext.popContext();
                            IvyContext parentContext = IvyContext.getContext();
                            HashMap<MDArtifact, DefaultArtifact> workspaceArtifacts = (HashMap<MDArtifact, DefaultArtifact>)parentContext.get(IVYDE_WORKSPACE_ARTIFACTS);
                            if (workspaceArtifacts == null) {
                                workspaceArtifacts = new HashMap<MDArtifact, DefaultArtifact>();
                                parentContext.set(IVYDE_WORKSPACE_ARTIFACTS, workspaceArtifacts);
                            }
                            int j = 0;
                            while (j < dArtifacts.length) {
                                MDArtifact artifact = new MDArtifact(md, dArtifacts[j].getName(), dArtifacts[j].getType(), dArtifacts[j].getExt(), dArtifacts[j].getUrl(), dArtifacts[j].getQualifiedExtraAttributes());
                                workspaceArtifacts.put(artifact, af);
                                ++j;
                            }
                            IvyContext.pushContext((IvyContext)currentContext);
                        }
                        DefaultModuleDescriptor workspaceMd = this.cloneMd(md, (Artifact)af);
                        MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport((Artifact)af);
                        madr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                        madr.setSearched(true);
                        return new ResolvedModuleRevision((DependencyResolver)this, (DependencyResolver)this, (ModuleDescriptor)workspaceMd, madr);
                    }
                    IvyDEMessage.verbose("\t\treject as version didn't match");
                }
            }
            ++i;
        }
        return null;
    }

    private DefaultModuleDescriptor cloneMd(ModuleDescriptor md, Artifact af) {
        DefaultModuleDescriptor newMd = new DefaultModuleDescriptor(md.getModuleRevisionId(), "release", null, true);
        newMd.addConfiguration(new Configuration("default"));
        newMd.setLastModified(System.currentTimeMillis());
        newMd.setDescription(md.getDescription());
        newMd.setHomePage(md.getHomePage());
        newMd.setLastModified(md.getLastModified());
        newMd.setPublicationDate(md.getPublicationDate());
        newMd.setResolvedPublicationDate(md.getResolvedPublicationDate());
        newMd.setStatus(md.getStatus());
        Configuration[] allConfs = md.getConfigurations();
        if (allConfs.length == 0) {
            newMd.addArtifact("default", af);
        } else {
            int k = 0;
            while (k < allConfs.length) {
                newMd.addConfiguration(allConfs[k]);
                newMd.addArtifact(allConfs[k].getName(), af);
                ++k;
            }
        }
        DependencyDescriptor[] dependencies = md.getDependencies();
        int k = 0;
        while (k < dependencies.length) {
            newMd.addDependency(dependencies[k]);
            ++k;
        }
        ExcludeRule[] allExcludeRules = md.getAllExcludeRules();
        int k2 = 0;
        while (k2 < allExcludeRules.length) {
            newMd.addExcludeRule(allExcludeRules[k2]);
            ++k2;
        }
        Map extraInfo = md.getExtraInfo();
        Iterator it = extraInfo.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            newMd.addExtraInfo((String)entry.getKey(), (String)entry.getValue());
        }
        License[] licenses = md.getLicenses();
        int k3 = 0;
        while (k3 < licenses.length) {
            newMd.addLicense(licenses[k3]);
            ++k3;
        }
        return newMd;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException("publish not supported by " + this.getName());
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        return null;
    }
}

