/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.core.workspace.SynchronizeGradleProjectJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GradleUtil {
    private static GradleRunConfigurationAttributes getRunConfigurationAttributes(IProject project, String task) {
        ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
        Optional requestAttributes = Optional.of((Object)projectConfiguration.getRequestAttributes());
        ArrayList<String> tasks = new ArrayList<String>();
        tasks.add(task);
        String projectDirectoryExpression = ExpressionUtils.encodeWorkspaceLocation((IProject)project);
        boolean isPresent = requestAttributes.isPresent();
        GradleDistribution gradleDistribution = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getGradleDistribution() : GradleDistribution.fromBuild();
        String gradleUserHome = isPresent ? (String)FileUtils.getAbsolutePath((File)((FixedRequestAttributes)requestAttributes.get()).getGradleUserHome()).orNull() : null;
        String javaHome = isPresent ? (String)FileUtils.getAbsolutePath((File)((FixedRequestAttributes)requestAttributes.get()).getJavaHome()).orNull() : null;
        ImmutableList jvmArguments = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getJvmArguments() : ImmutableList.of();
        ImmutableList arguments = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getArguments() : ImmutableList.of();
        boolean showExecutionView = true;
        boolean showConsoleView = true;
        return GradleRunConfigurationAttributes.with(tasks, (String)projectDirectoryExpression, (GradleDistribution)gradleDistribution, (String)gradleUserHome, (String)javaHome, (List)jvmArguments, (List)arguments, (boolean)showExecutionView, (boolean)showConsoleView);
    }

    public static IStatus importGradleProject(File dir, IProgressMonitor monitor) throws CoreException {
        ProjectImportConfiguration configuration = new ProjectImportConfiguration();
        GradleDistributionWrapper from = GradleDistributionWrapper.from((GradleDistribution)GradleDistribution.fromBuild());
        configuration.setGradleDistribution(from);
        configuration.setProjectDir(dir);
        configuration.setApplyWorkingSets(Boolean.valueOf(false));
        configuration.setWorkingSets(new ArrayList());
        SynchronizeGradleProjectJob synchronizeGradleProjectJob = new SynchronizeGradleProjectJob(configuration.toFixedAttributes(), (List)configuration.getWorkingSets().getValue(), AsyncHandler.NO_OP);
        synchronizeGradleProjectJob.setUser(true);
        return synchronizeGradleProjectJob.runInWorkspace(monitor);
    }

    public static boolean isBuildFile(IFile buildFile) {
        return buildFile != null && buildFile.exists() && "build.gradle".equals(buildFile.getName()) && buildFile.getParent() instanceof IProject;
    }

    public static boolean isGradleProject(IProject project) throws CoreException {
        return project != null && project.exists() && project.isAccessible() && project.hasNature("org.eclipse.buildship.core.gradleprojectnature");
    }

    public static void runGradleTask(IProject project, String task, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration launchConfiguration = CorePlugin.gradleLaunchConfigurationManager().getOrCreateRunConfiguration(GradleUtil.getRunConfigurationAttributes(project, task));
        ILaunchConfigurationWorkingCopy launchConfigurationWC = launchConfiguration.getWorkingCopy();
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", true);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
        launchConfigurationWC.doSave();
        launchConfigurationWC.launch("run", monitor);
    }
}

