/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import aQute.bnd.osgi.Jar;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.liferay.ide.core.BaseLiferayProject;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.toolingapi.custom.CustomModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.GradleRunConfigurationDelegate;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;

public class LiferayGradleProject
extends BaseLiferayProject
implements IBundleProject {
    private static final String[] ignorePaths = new String[]{".gradle", "build"};

    public LiferayGradleProject(IProject project) {
        super(project);
    }

    public boolean filterResource(IPath resourcePath) {
        return this.filterResource(resourcePath, ignorePaths);
    }

    public IFile getDescriptorFile(String name) {
        return null;
    }

    public IPath getLibraryPath(String filename) {
        return null;
    }

    public IPath getOutputBundle(boolean build, IProgressMonitor monitor) throws CoreException {
        IPath outputBundle = LiferayGradleProject.getOutputBundle(this.getProject());
        if (!build && outputBundle != null && outputBundle.toFile().exists()) {
            return outputBundle;
        }
        String task = this.isThemeProject(this.getProject()) ? "build" : "jar";
        ILaunchConfiguration launchConfiguration = CorePlugin.gradleLaunchConfigurationManager().getOrCreateRunConfiguration(this.getRunConfigurationAttributes(task));
        final ILaunchConfigurationWorkingCopy launchConfigurationWC = launchConfiguration.getWorkingCopy();
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", false);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
        String jobTitle = "Building " + this.getProject().getName() + " output...";
        Job job = new Job(jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new GradleRunConfigurationDelegate().launch((ILaunchConfiguration)launchConfigurationWC, "run", (ILaunch)new Launch((ILaunchConfiguration)launchConfigurationWC, "run", null), monitor);
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        };
        monitor.subTask(jobTitle);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        outputBundle = LiferayGradleProject.getOutputBundle(this.getProject());
        if (outputBundle.toFile().exists()) {
            return outputBundle;
        }
        return null;
    }

    private boolean isThemeProject(IProject project) {
        return project.getFile("gulpfile.js").exists() && project.getFile("package.json").exists() && project.getFile("src/WEB-INF/liferay-plugin-package.properties").exists();
    }

    public String getProperty(String key, String defaultValue) {
        return null;
    }

    public String getSymbolicName() throws CoreException {
        String retval = null;
        IPath outputBundle = LiferayGradleProject.getOutputBundle(this.getProject());
        if (outputBundle == null || outputBundle.lastSegment().endsWith(".war")) {
            return this.getProject().getName();
        }
        if (outputBundle != null && outputBundle.toFile().exists()) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (Jar jar = new Jar(outputBundle.toFile());){
                    retval = jar.getBsn();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static IPath getOutputBundle(IProject gradleProject) {
        CustomModel model = GradleCore.getToolingModel(CustomModel.class, gradleProject);
        Set outputFiles = model.getOutputFiles();
        if (outputFiles.size() > 0) {
            return new Path(((File)outputFiles.iterator().next()).getAbsolutePath());
        }
        if (model.hasPlugin("com.liferay.gradle.plugins.gulp.GulpPlugin")) {
            return gradleProject.getLocation().append("dist/" + gradleProject.getName() + ".war");
        }
        return null;
    }

    private GradleRunConfigurationAttributes getRunConfigurationAttributes(String task) {
        ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(this.getProject());
        Optional requestAttributes = Optional.of((Object)projectConfiguration.getRequestAttributes());
        ArrayList<String> tasks = new ArrayList<String>();
        tasks.add(task);
        String projectDirectoryExpression = ExpressionUtils.encodeWorkspaceLocation((IProject)this.getProject());
        boolean isPresent = requestAttributes.isPresent();
        GradleDistribution gradleDistribution = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getGradleDistribution() : GradleDistribution.fromBuild();
        String gradleUserHome = isPresent ? (String)FileUtils.getAbsolutePath((File)((FixedRequestAttributes)requestAttributes.get()).getGradleUserHome()).orNull() : null;
        String javaHome = isPresent ? (String)FileUtils.getAbsolutePath((File)((FixedRequestAttributes)requestAttributes.get()).getJavaHome()).orNull() : null;
        ImmutableList jvmArguments = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getJvmArguments() : ImmutableList.of();
        ImmutableList arguments = isPresent ? ((FixedRequestAttributes)requestAttributes.get()).getArguments() : ImmutableList.of();
        boolean showExecutionView = true;
        boolean showConsoleView = true;
        return GradleRunConfigurationAttributes.with(tasks, (String)projectDirectoryExpression, (GradleDistribution)gradleDistribution, (String)gradleUserHome, (String)javaHome, (List)jvmArguments, (List)arguments, (boolean)showExecutionView, (boolean)showConsoleView);
    }
}

