/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.workspace;

import com.liferay.ide.gradle.core.LiferayWorkspaceProjectProvider;
import com.liferay.ide.gradle.core.workspace.ImportLiferayWorkspaceOp;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class ImportLiferayWorkspaceOpMethods {
    public static final Status execute(ImportLiferayWorkspaceOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Importing Liferay Workspace project...", 100);
        Status retval = null;
        try {
            LiferayWorkspaceProjectProvider provider = new LiferayWorkspaceProjectProvider();
            String location = ((org.eclipse.sapphire.modeling.Path)op.getWorkspaceLocation().content()).toOSString();
            LiferayWorkspaceUtil.clearWorkspace((String)location);
            boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
            boolean isHasBundlesDir = (Boolean)op.getHasBundlesDir().content();
            IStatus importStatus = null;
            importStatus = isInitBundle && !isHasBundlesDir ? provider.importProject(location, monitor, "initBundle") : provider.importProject(location, monitor, null);
            retval = StatusBridge.create((IStatus)importStatus);
            if (!retval.ok()) {
                return retval;
            }
            if (isInitBundle || isHasBundlesDir) {
                String serverRuntimeName = (String)op.getServerName().content();
                ImportLiferayWorkspaceOpMethods.addPortalRuntimeAndServer(serverRuntimeName, location, monitor);
            }
        }
        catch (Exception e) {
            ProjectCore.logError((String)"import Liferay Workspace project error", (Exception)e);
            retval = Status.createErrorStatus((String)"import Liferay Workspace project error", (Throwable)e);
        }
        return retval;
    }

    public static void addPortalRuntimeAndServer(String serverRuntimeName, String location, IProgressMonitor monitor) throws CoreException {
        IRuntimeWorkingCopy runtimeWC = ServerCore.findRuntimeType((String)"com.liferay.ide.server.portal.runtime").createRuntime(serverRuntimeName, monitor);
        Path runTimePath = new Path(location);
        runtimeWC.setName(serverRuntimeName);
        runtimeWC.setLocation(runTimePath.append("bundles"));
        runtimeWC.save(true, monitor);
        IServerWorkingCopy serverWC = ServerCore.findServerType((String)"com.liferay.ide.server.portal").createServer(serverRuntimeName, null, (IRuntime)runtimeWC, monitor);
        serverWC.setName(serverRuntimeName);
        serverWC.save(true, monitor);
    }
}

