/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.workspace;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.gradle.core.LiferayWorkspaceProjectProvider;
import com.liferay.ide.gradle.core.workspace.ImportLiferayWorkspaceOpMethods;
import com.liferay.ide.gradle.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.project.core.ProjectCore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class NewLiferayWorkspaceOpMethods {
    public static final Status execute(NewLiferayWorkspaceOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay Workspace project...", 100);
        Status retval = null;
        try {
            Path projectLocation = (Path)op.getLocation().content();
            NewLiferayWorkspaceOpMethods.updateLocation(op, projectLocation);
            LiferayWorkspaceProjectProvider provider = (LiferayWorkspaceProjectProvider)LiferayCore.getProvider((String)"liferay-workspace");
            IStatus createStatus = provider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)createStatus);
            if (!retval.ok()) {
                return retval;
            }
            String location = projectLocation.toOSString();
            boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
            IStatus importStatus = null;
            importStatus = isInitBundle ? provider.importProject(location, monitor, "initBundle") : provider.importProject(location, monitor, null);
            retval = StatusBridge.create((IStatus)importStatus);
            if (!retval.ok()) {
                return retval;
            }
            if (isInitBundle) {
                String serverRuntimeName = (String)op.getServerName().content();
                ImportLiferayWorkspaceOpMethods.addPortalRuntimeAndServer(serverRuntimeName, location, monitor);
            }
        }
        catch (Exception e) {
            ProjectCore.logError((String)"Error creating Liferay Workspace project.", (Exception)e);
            return Status.createErrorStatus((String)"Error creating Liferay Workspace project.", (Throwable)e);
        }
        return retval;
    }

    public static void updateLocation(NewLiferayWorkspaceOp op, Path baseLocation) {
        String projectName = (String)op.getWorkspaceName().content();
        if (baseLocation == null) {
            return;
        }
        String lastSegment = baseLocation.lastSegment();
        if (baseLocation != null && baseLocation.segmentCount() > 0 && lastSegment.equals(projectName)) {
            return;
        }
        Path newLocation = baseLocation.append(projectName);
        op.setLocation(newLocation);
    }
}

