/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;

public class LaunchWorkspaceHandler
extends AbstractHandler {
    static final String COMMAND_ID = "com.liferay.ide.ui.workspace.launchWorkspace";
    static final String PARAM_WORKSPACE_LOCATION = "workspaceLocation";
    static final String PARAM_LIFERAY_7_SDK_DIR = "liferay7SDKDir";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        File launchDir;
        ArrayList<String> commands;
        block32: {
            block30: {
                File launcher;
                String workspaceLocation;
                String liferay7SDKDir;
                block29: {
                    block27: {
                        liferay7SDKDir = event.getParameter(PARAM_LIFERAY_7_SDK_DIR);
                        workspaceLocation = event.getParameter(PARAM_WORKSPACE_LOCATION);
                        if (workspaceLocation == null) {
                            ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData(Platform.getInstallLocation().getURL());
                            ChooseWorkspaceDialog chooseWorkspaceDialog = new ChooseWorkspaceDialog(Display.getDefault().getActiveShell(), chooseWorkspaceData, true, true);
                            if (chooseWorkspaceDialog.open() == 0) {
                                workspaceLocation = chooseWorkspaceData.getSelection();
                            } else {
                                return null;
                            }
                        }
                        commands = new ArrayList<String>();
                        launchDir = new File(Platform.getInstallLocation().getURL().getFile());
                        if (!launchDir.exists()) break block27;
                        switch (Platform.getOS()) {
                            case "macosx": {
                                launcher = launchDir.getParentFile().getParentFile();
                                break;
                            }
                            default: {
                                launcher = new File(System.getProperty("eclipse.launcher"));
                                break;
                            }
                        }
                        break block29;
                    }
                    launcher = null;
                }
                if (launcher == null || !launcher.exists()) break block30;
                switch (Platform.getOS()) {
                    case "macosx": {
                        commands.add("open");
                        commands.add("-n");
                        commands.add(launcher.getAbsolutePath());
                        commands.add("--args");
                        break;
                    }
                    case "linux": {
                        commands.add("/bin/bash");
                        commands.add("-c");
                        commands.add("./" + launcher.getName());
                        break;
                    }
                    case "win32": {
                        commands.add("cmd");
                        commands.add("/c");
                        commands.add(launcher.getName());
                    }
                }
                commands.add("-data");
                commands.add(workspaceLocation);
                if (liferay7SDKDir != null) {
                    commands.add("-vmargs");
                    commands.add("-Dliferay7.sdk.dir=\"" + liferay7SDKDir + "\"");
                }
                break block32;
            }
            throw new ExecutionException("Unable to find Eclipse launcher.");
        }
        if (launchDir.isDirectory()) {
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            processBuilder.directory(launchDir);
            processBuilder.environment().putAll(System.getenv());
            try {
                processBuilder.start();
            }
            catch (IOException e) {
                throw new ExecutionException("Unable to start Eclipse process.", (Throwable)e);
            }
        }
        return null;
    }
}

