/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.workspace;

import com.liferay.ide.ui.workspace.LaunchLiferay7WorkspaceAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class LaunchWorkspaceMenu
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        IContributionItem[] workspaceHistoryItems;
        MenuManager menu = new MenuManager("Launch Workspace");
        menu.add((IAction)new LaunchLiferay7WorkspaceAction());
        menu.add((IContributionItem)new Separator());
        IContributionItem[] iContributionItemArray = workspaceHistoryItems = this.buildWorkspaceHistory(serviceLocator);
        int n = workspaceHistoryItems.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem workspaceHistoryItem = iContributionItemArray[n2];
            if (workspaceHistoryItem instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)workspaceHistoryItem;
                if ("Other...".equals(commandItem.getData().label)) {
                    menu.add((IContributionItem)new Separator());
                }
            }
            menu.add(workspaceHistoryItem);
            ++n2;
        }
        additions.addContributionItem((IContributionItem)menu, null);
    }

    private IContributionItem[] buildWorkspaceHistory(IServiceLocator serviceLocator) {
        ArrayList<IContributionItem> retval = new ArrayList<IContributionItem>();
        ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
        if (chooseWorkspaceData.readPersistedData()) {
            String[] recentWorkspaces;
            String currentWorkspace = chooseWorkspaceData.getInitialDefault();
            String[] stringArray = recentWorkspaces = chooseWorkspaceData.getRecentWorkspaces();
            int n = recentWorkspaces.length;
            int n2 = 0;
            while (n2 < n) {
                String recentWorkspace = stringArray[n2];
                if (recentWorkspace != null && !recentWorkspace.equals(currentWorkspace)) {
                    retval.add(this.newLaunchWorkspaceCommand(serviceLocator, recentWorkspace, recentWorkspace));
                }
                ++n2;
            }
            retval.add(this.newLaunchWorkspaceCommand(serviceLocator, "Other...", null));
        }
        return retval.toArray(new IContributionItem[0]);
    }

    private IContributionItem newLaunchWorkspaceCommand(IServiceLocator serviceLocator, String label, String workspaceLocation) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(serviceLocator, "", "com.liferay.ide.ui.workspace.launchWorkspace", 8);
        if (workspaceLocation != null) {
            parameter.parameters = new HashMap();
            parameter.parameters.put("workspaceLocation", workspaceLocation);
        }
        parameter.label = label;
        CommandContributionItem launchWorkspaceCommand = new CommandContributionItem(parameter);
        launchWorkspaceCommand.setVisible(true);
        return launchWorkspaceCommand;
    }
}

