/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.search.editor.internal.contentassist.util;

import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TaglibUtils {
    public static String getTagURI(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                Attr attr = (Attr)node;
                return TaglibUtils.getTagURI(attr);
            }
            case 1: {
                Element element = (Element)node;
                return TaglibUtils.getTagURI(element);
            }
        }
        return null;
    }

    public static String getTagURI(Attr attr) {
        CMDocument doc;
        CMAttributeDeclaration decl = TaglibUtils.getAttributeDeclaration(attr);
        if (decl == null) {
            return null;
        }
        if (decl instanceof TLDAttributeDeclaration && (doc = ((TLDAttributeDeclaration)decl).getOwnerDocument()) instanceof TLDDocument) {
            return ((TLDDocument)doc).getUri();
        }
        return null;
    }

    public static String getTagURI(Element element) {
        CMDocument doc;
        CMElementDeclaration decl = TaglibUtils.getElementDeclaration(element);
        if (decl == null) {
            return null;
        }
        if (decl instanceof TLDElementDeclaration && (doc = ((TLDElementDeclaration)decl).getOwnerDocument()) instanceof TLDDocument) {
            return ((TLDDocument)doc).getUri();
        }
        return null;
    }

    public static CMAttributeDeclaration getAttributeDeclaration(Attr attr) {
        if (attr == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)attr.getOwnerDocument();
        if (notifier == null) {
            return null;
        }
        ModelQueryAdapter mqa = (ModelQueryAdapter)notifier.getAdapterFor(ModelQueryAdapter.class);
        if (mqa == null) {
            return null;
        }
        return mqa.getModelQuery().getCMAttributeDeclaration(attr);
    }

    public static CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)element.getOwnerDocument();
        if (notifier == null) {
            return null;
        }
        ModelQueryAdapter mqa = (ModelQueryAdapter)notifier.getAdapterFor(ModelQueryAdapter.class);
        if (mqa == null) {
            return null;
        }
        return mqa.getModelQuery().getCMElementDeclaration(element);
    }
}

