/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.platform;

import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.internal.platform.InternalJaxbPlatformGroupConfig;
import org.eclipse.jpt.jaxb.core.internal.platform.InternalJaxbPlatformManager;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinitionFactory;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

class InternalJaxbPlatformConfig
implements JaxbPlatformConfig {
    private final InternalJaxbPlatformManager jaxbPlatformManager;
    private final String id;
    private final String label;
    private final String factoryClassName;
    private IProjectFacetVersion jaxbFacetVersion;
    private boolean default_ = false;
    private InternalJaxbPlatformGroupConfig group;
    private String pluginId;
    private JaxbPlatformDefinition jaxbPlatformDefinition;

    InternalJaxbPlatformConfig(InternalJaxbPlatformManager jaxbPlatformManager, String id, String label, String factoryClassName) {
        this.jaxbPlatformManager = jaxbPlatformManager;
        this.id = id;
        this.label = label;
        this.factoryClassName = factoryClassName;
    }

    public JaxbPlatformManager getJaxbPlatformManager() {
        return this.jaxbPlatformManager;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    void setJaxbFacetVersion(IProjectFacetVersion jaxbFacetVersion) {
        this.jaxbFacetVersion = jaxbFacetVersion;
    }

    public boolean supportsJaxbFacetVersion(IProjectFacetVersion version) {
        if (!version.getProjectFacet().equals(JaxbProject.FACET)) {
            throw new IllegalArgumentException(version.toString());
        }
        return this.jaxbFacetVersion == null || this.jaxbFacetVersion.equals(version);
    }

    public boolean isDefault() {
        return this.default_;
    }

    void setDefault(boolean default_) {
        this.default_ = default_;
    }

    public JaxbPlatformGroupConfig getGroupConfig() {
        return this.group;
    }

    void setGroup(InternalJaxbPlatformGroupConfig group) {
        this.group = group;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    synchronized JaxbPlatformDefinition getJaxbPlatformDefinition() {
        if (this.jaxbPlatformDefinition == null) {
            this.jaxbPlatformDefinition = this.buildJaxbPlatformDefinition();
        }
        return this.jaxbPlatformDefinition;
    }

    private JaxbPlatformDefinition buildJaxbPlatformDefinition() {
        JaxbPlatformDefinitionFactory factory = this.buildJaxbPlatformDefinitionFactory();
        return factory == null ? null : factory.buildJaxbPlatformDefinition();
    }

    private JaxbPlatformDefinitionFactory buildJaxbPlatformDefinitionFactory() {
        return (JaxbPlatformDefinitionFactory)ExtensionPointTools.instantiate((String)this.pluginId, (String)this.jaxbPlatformManager.getExtensionPointName(), (String)this.factoryClassName, JaxbPlatformDefinitionFactory.class);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.label);
    }
}

