/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.IXMLSearchEngine;
import org.eclipse.wst.xml.search.core.internal.AbstractXMLSearchEngine;
import org.eclipse.wst.xml.search.core.internal.XMLSearchCorePlugin;
import org.eclipse.wst.xml.search.core.internal.queryspecifications.XMLQuerySpecification2;
import org.eclipse.wst.xml.search.core.internal.reporter.XMLSearchReporterIdProvider;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.IExecutableXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.queryspecifications.XMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AllFilesXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;

public class XMLSearchEngine
extends AbstractXMLSearchEngine
implements IXMLSearchEngine {
    private static final XMLSearchEngine INSTANCE = new XMLSearchEngine();

    public static IXMLSearchEngine getDefault() {
        return INSTANCE;
    }

    @Override
    protected void search(IFile[] files, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor, MultiStatus status) {
        IFile file = null;
        int i = 0;
        while (i < files.length) {
            file = files[i];
            this.processFile(file, (IResource)file, AllFilesXMLSearchRequestor.INSTANCE, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, status);
            ++i;
        }
    }

    @Override
    public IStatus search(IXMLQuerySpecificationRegistry querySpecificationRegistry, IXMLSearchDOMNodeCollector collector, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        long startTime = -1L;
        int searchId = -1;
        if (this.isReporterEnabled(reporter)) {
            searchId = XMLSearchReporterIdProvider.getSearchId();
            startTime = System.currentTimeMillis();
            HashMap<IResource, Collection<String>> containersReporter = new HashMap<IResource, Collection<String>>();
            Set<Map.Entry<IResource, Collection<IExecutableXMLQuerySpecification>>> entries = querySpecificationRegistry.getQuerySpecificationsMap().entrySet();
            for (Map.Entry<IResource, Collection<IExecutableXMLQuerySpecification>> entry : entries) {
                IResource container = entry.getKey();
                ArrayList<String> queries = new ArrayList<String>();
                Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications = entry.getValue();
                for (IExecutableXMLQuerySpecification executableXMLQuerySpecification : executableXMLQuerySpecifications) {
                    queries.add(executableXMLQuerySpecification.getQuery());
                }
                containersReporter.put(container, queries);
            }
            reporter.beginSearch(searchId, containersReporter);
        }
        MultiStatus status = this.createStatus();
        try {
            this.search(querySpecificationRegistry, collector, monitor, status);
        }
        finally {
            if (searchId != -1) {
                reporter.endSearch(searchId, System.currentTimeMillis() - startTime);
            }
        }
        return status;
    }

    protected void search(IXMLQuerySpecificationRegistry querySpecificationRegistry, IXMLSearchDOMNodeCollector collector, IProgressMonitor monitor, MultiStatus status) {
        Set<Map.Entry<IResource, Collection<IExecutableXMLQuerySpecification>>> entries = querySpecificationRegistry.getQuerySpecificationsMap().entrySet();
        for (Map.Entry<IResource, Collection<IExecutableXMLQuerySpecification>> entry : entries) {
            IResource container = entry.getKey();
            Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications = entry.getValue();
            this.search(container, container, executableXMLQuerySpecifications, collector, status);
        }
    }

    protected void search(IResource resource, IResource rootResource, Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications, IXMLSearchDOMNodeCollector collector, MultiStatus status) {
        if (this.acceptResource(resource, rootResource, executableXMLQuerySpecifications)) {
            int resourceType = resource.getType();
            switch (resourceType) {
                case 1: {
                    IFile file = (IFile)resource;
                    this.processFile(file, rootResource, executableXMLQuerySpecifications, collector, status);
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    try {
                        IResource[] resources = ((IContainer)resource).members();
                        this.search(resources, rootResource, executableXMLQuerySpecifications, collector, status);
                        break;
                    }
                    catch (CoreException e) {
                        status.add(XMLSearchCorePlugin.createStatus(4, e.getMessage(), e));
                    }
                }
            }
        }
    }

    private void search(IResource[] resources, IResource rootResource, Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications, IXMLSearchDOMNodeCollector collector, MultiStatus status) {
        int i = 0;
        while (i < resources.length) {
            this.search(resources[i], rootResource, executableXMLQuerySpecifications, collector, status);
            ++i;
        }
    }

    private boolean acceptResource(IResource resource, IResource rootResource, Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications) {
        if (resource == null) {
            return false;
        }
        for (IExecutableXMLQuerySpecification executableXMLQuerySpecification : executableXMLQuerySpecifications) {
            if (!this.acceptResource(resource, rootResource, executableXMLQuerySpecification)) continue;
            return true;
        }
        return false;
    }

    private boolean acceptResource(IResource resource, IResource rootResource, IExecutableXMLQuerySpecification executableXMLQuerySpecification) {
        IXMLSearchRequestor requestor = executableXMLQuerySpecification.getRequestor();
        return requestor != null && requestor.accept(resource, rootResource);
    }

    protected void processFile(IFile file, IResource rootResource, Collection<IExecutableXMLQuerySpecification> executableXMLQuerySpecifications, IXMLSearchDOMNodeCollector collector, MultiStatus status) {
        for (IExecutableXMLQuerySpecification executableXMLQuerySpecification : executableXMLQuerySpecifications) {
            if (!this.acceptResource((IResource)file, rootResource, executableXMLQuerySpecification)) continue;
            super.processFile(file, rootResource, executableXMLQuerySpecification.getRequestor(), executableXMLQuerySpecification.getVisitor(), executableXMLQuerySpecification.getQuery(), executableXMLQuerySpecification.getXPathProcessorId(), executableXMLQuerySpecification.getNamespaces(), collector, executableXMLQuerySpecification.getSelectedNode(), status);
        }
    }

    @Override
    public IStatus search(IResource container, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        XMLQuerySpecificationRegistry querySpecificationRegistry = new XMLQuerySpecificationRegistry(container, selectedNode);
        XMLQuerySpecification2 specification = XMLQuerySpecification2.newDefaultQuerySpecification(container);
        specification.setVisitor(visitor);
        specification.setRequestor(requestor);
        specification.setXPathProcessorId(xpathProcessorId);
        querySpecificationRegistry.register(specification, query, namespaceInfos);
        return this.search((IXMLQuerySpecificationRegistry)querySpecificationRegistry, collector, reporter, monitor);
    }

    @Override
    public IStatus search(IResource[] containers, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathProcessorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        XMLQuerySpecificationRegistry querySpecificationRegistry = new XMLQuerySpecificationRegistry(null, selectedNode);
        XMLQuerySpecification2 specification = XMLQuerySpecification2.newDefaultQuerySpecification(containers);
        specification.setVisitor(visitor);
        specification.setRequestor(requestor);
        specification.setXPathProcessorId(xpathProcessorId);
        querySpecificationRegistry.register(specification, query, namespaceInfos);
        return this.search((IXMLQuerySpecificationRegistry)querySpecificationRegistry, collector, reporter, monitor);
    }

    @Override
    public IStatus search(IStorage storage, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IStatus search(IStorage[] storages, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        return null;
    }
}

