/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal.resource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.queryspecifications.container.FolderContainerProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IMultiResourceProvider;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IResourceProvider;
import org.eclipse.wst.xml.search.core.resource.DefaultResourceRequestor;
import org.eclipse.wst.xml.search.core.resource.DefaultURIResolverProvider;
import org.eclipse.wst.xml.search.core.resource.IResourceQuerySpecification;
import org.eclipse.wst.xml.search.core.resource.IResourceRequestor;
import org.eclipse.wst.xml.search.core.resource.IResourceRequestorProvider;
import org.eclipse.wst.xml.search.core.resource.IURIResolver;
import org.eclipse.wst.xml.search.core.resource.IURIResolverProvider;

public class ResourceQuerySpecification
implements IResourceQuerySpecification {
    public static final IResourceQuerySpecification DEFAULT = ResourceQuerySpecification.newDefaultQuerySpecification();
    private IResourceProvider containerProvider;
    private IMultiResourceProvider multiContainerProvider;
    private IResourceRequestor requestor;
    private IURIResolverProvider resolverProvider;

    protected ResourceQuerySpecification(IResourceProvider containerProvider, IMultiResourceProvider multiContainerProvider, IResourceRequestor requestor, IURIResolverProvider resolverProvider) {
        this.containerProvider = containerProvider;
        this.multiContainerProvider = multiContainerProvider;
        this.requestor = requestor;
        this.resolverProvider = resolverProvider;
    }

    @Override
    public IResource getResource(Object selectedNode, IResource resource) {
        return this.containerProvider.getResource(selectedNode, resource);
    }

    @Override
    public IResourceRequestor getRequestor() {
        return this.requestor;
    }

    @Override
    public IURIResolver getURIResolver(IFile file, Object selectedNode) {
        return this.resolverProvider.getURIResolver(file, selectedNode);
    }

    public static IResourceQuerySpecification newDefaultQuerySpecification() {
        return new ResourceQuerySpecification(FolderContainerProvider.INSTANCE, null, DefaultResourceRequestor.INSTANCE, DefaultURIResolverProvider.INSTANCE);
    }

    public static IResourceQuerySpecification newQuerySpecification(Object querySpecification) {
        ResourceQuerySpecification specification = (ResourceQuerySpecification)ResourceQuerySpecification.newDefaultQuerySpecification();
        if (querySpecification instanceof IResourceProvider) {
            specification.setContainerProvider((IResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IMultiResourceProvider) {
            specification.setMultiContainerProvider((IMultiResourceProvider)querySpecification);
        }
        if (querySpecification instanceof IResourceRequestorProvider) {
            specification.setRequestor(((IResourceRequestorProvider)querySpecification).getRequestor());
        }
        if (querySpecification instanceof IURIResolverProvider) {
            specification.setURIResolverProvider((IURIResolverProvider)querySpecification);
        }
        return specification;
    }

    private void setMultiContainerProvider(IMultiResourceProvider multiContainerProvider) {
        this.multiContainerProvider = multiContainerProvider;
    }

    private void setURIResolverProvider(IURIResolverProvider resolverProvider) {
        this.resolverProvider = resolverProvider;
    }

    private void setRequestor(IResourceRequestor requestor) {
        this.requestor = requestor;
    }

    private void setContainerProvider(IResourceProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    @Override
    public boolean isMultiResource() {
        return this.multiContainerProvider != null;
    }

    @Override
    public IResource[] getResources(Object selectedNode, IResource resource) {
        return this.multiContainerProvider.getResources(selectedNode, resource);
    }
}

