/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import tern.ITernFile;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.views.TernOutline;
import tern.server.ITernPlugin;
import tern.server.TernPlugin;
import tern.server.protocol.outline.ITernOutlineCollector;
import tern.server.protocol.outline.JSNode;
import tern.server.protocol.outline.JSNodeRoot;
import tern.server.protocol.outline.TernOutlineQuery;

public class TernOutlineContentProvider
implements ITreeContentProvider,
IDocumentListener {
    public static final Object COMPUTING_NODE = new Object();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int UPDATE_DELAY = 500;
    private Viewer viewer;
    private TernDocumentFile document;
    private Job refreshJob = new Job(TernUIMessages.refreshOutline){

        protected IStatus run(IProgressMonitor monitor) {
            TernOutlineContentProvider.this.parsed = false;
            if (TernOutlineContentProvider.this.document == null) {
                return Status.OK_STATUS;
            }
            try {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)TernOutlineContentProvider.this.document.getFile().getProject());
                if (ternProject != null && ternProject.hasPlugin((ITernPlugin)TernPlugin.outline)) {
                    TernOutlineQuery query = new TernOutlineQuery(TernOutlineContentProvider.this.document.getFileName());
                    TernOutlineContentProvider.this.outline = new TernOutline(TernOutlineContentProvider.this.document);
                    ternProject.request(query, (ITernFile)TernOutlineContentProvider.this.document, (ITernOutlineCollector)TernOutlineContentProvider.this.outline);
                    TernOutlineContentProvider.this.parsed = true;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Control refreshControl = TernOutlineContentProvider.this.viewer.getControl();
                            if (refreshControl != null && !refreshControl.isDisposed()) {
                                TreePath[] expendedPaths = null;
                                if (TernOutlineContentProvider.this.viewer instanceof TreeViewer) {
                                    expendedPaths = ((TreeViewer)TernOutlineContentProvider.this.viewer).getExpandedTreePaths();
                                }
                                TernOutlineContentProvider.this.viewer.refresh();
                                if (TernOutlineContentProvider.this.viewer instanceof TreeViewer && expendedPaths != null) {
                                    ((TreeViewer)TernOutlineContentProvider.this.viewer).setExpandedTreePaths(TernOutlineContentProvider.this.toNewTreePaths(expendedPaths, TernOutlineContentProvider.this.outline.getRoot()));
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    };
    private boolean parsed = false;
    private TernOutline outline = null;

    public TernOutlineContentProvider() {
        this.refreshJob.setSystem(true);
        this.refreshJob.setPriority(20);
    }

    private TreePath[] toNewTreePaths(TreePath[] originExpandedPaths, JSNodeRoot newRoot) {
        ArrayList<TreePath> res = new ArrayList<TreePath>();
        TreePath[] treePathArray = originExpandedPaths;
        int n = originExpandedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath originExpanded = treePathArray[n2];
            int i = 0;
            ArrayList<Object> newPathItems = new ArrayList<Object>();
            JSNodeRoot previousJSNode = null;
            while (i < originExpanded.getSegmentCount()) {
                Object originSegment = originExpanded.getSegment(i);
                if (originSegment instanceof JSNode) {
                    JSNode originNode = (JSNode)originSegment;
                    Object matchingNode = null;
                    matchingNode = previousJSNode == null ? (originNode instanceof JSNodeRoot ? newRoot : this.findSimilarChild((JSNode)newRoot, originNode)) : this.findSimilarChild((JSNode)previousJSNode, originNode);
                    if (matchingNode != null) {
                        newPathItems.add(matchingNode);
                        previousJSNode = matchingNode;
                    }
                } else {
                    newPathItems.add(originSegment);
                }
                ++i;
            }
            res.add(new TreePath(newPathItems.toArray()));
            ++n2;
        }
        return res.toArray(new TreePath[res.size()]);
    }

    private JSNode findSimilarChild(JSNode newParentNode, JSNode originChildNode) {
        JSNode matchingNode = null;
        if (originChildNode.getName() != null) {
            for (JSNode child : newParentNode.getChildren()) {
                if (child.getName() == null || !child.getName().equals(originChildNode.getName())) continue;
                matchingNode = child;
            }
        }
        if (matchingNode == null) {
            matchingNode = (JSNode)newParentNode.getChildren().get(originChildNode.getParent().getChildren().indexOf(originChildNode));
        }
        return matchingNode;
    }

    public Object[] getElements(Object element) {
        if (!this.parsed) {
            return new Object[]{COMPUTING_NODE};
        }
        return this.outline.getRoot().getChildren().toArray();
    }

    public Object[] getChildren(Object element) {
        if (element instanceof JSNode) {
            return ((JSNode)element).getChildren().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof JSNode) {
            return ((JSNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof JSNode) {
            return ((JSNode)element).hasChidren();
        }
        return false;
    }

    public void dispose() {
        this.refreshJob.cancel();
        this.document.getDocument().removeDocumentListener((IDocumentListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.document != null) {
            this.document.getDocument().removeDocumentListener((IDocumentListener)this);
        }
        if (newInput instanceof TernDocumentFile) {
            this.document = (TernDocumentFile)newInput;
        } else if (newInput instanceof IAdaptable) {
            this.document = (TernDocumentFile)((IAdaptable)newInput).getAdapter(TernDocumentFile.class);
        }
        if (this.document != null) {
            this.document.getDocument().addDocumentListener((IDocumentListener)this);
        }
        this.refreshJob.schedule();
    }

    public void documentChanged(DocumentEvent event) {
        if (this.refreshJob.getState() != 0) {
            this.refreshJob.cancel();
        }
        this.refreshJob.schedule(500L);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }
}

