/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references.validators;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;

public class XMLReferenceValidatorsManager
extends AbstractRegistryManager {
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String FILTER_ELT = "validator";
    public static final XMLReferenceValidatorsManager INSTANCE = new XMLReferenceValidatorsManager();
    private static final String XML_REFERENCE_FILTERS_EXTENSION_POINT = "referenceValidators";
    private Map<String, IXMLReferenceValidator> validatorsById = null;

    public static XMLReferenceValidatorsManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.validatorsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addXMLReferenceValidators(this.validatorsById, cf);
        }
    }

    private synchronized void addXMLReferenceValidators(Map<String, IXMLReferenceValidator> providersById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (FILTER_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    IXMLReferenceValidator provider = (IXMLReferenceValidator)ce.createExecutableExtension(CLASS_ATTR);
                    providersById.put(id, provider);
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load XML references validators for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IXMLReferenceValidator getProvider(String referenceId) {
        if (StringUtils.isEmpty((String)referenceId)) {
            return null;
        }
        if (this.validatorsById == null) {
            this.loadXMLReferenceValidators();
        }
        return this.validatorsById.get(referenceId);
    }

    private synchronized void loadXMLReferenceValidators() {
        if (this.validatorsById != null) {
            return;
        }
        HashMap<String, IXMLReferenceValidator> providersById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", XML_REFERENCE_FILTERS_EXTENSION_POINT);
            providersById = new HashMap(cf.length);
            this.addXMLReferenceValidators(providersById, cf);
        } else {
            providersById = new HashMap<String, IXMLReferenceValidator>();
        }
        this.validatorsById = providersById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return XML_REFERENCE_FILTERS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

