/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.searchers.javamethod;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.searchers.javamethod.JavaMethodQuerySpecification;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.IJavaMethodQuerySpecification;

public class JavaMethodQuerySpecificationrManager
extends AbstractRegistryManager {
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String QUERY_SPECIFICATION_ELT = "querySpecification";
    public static final JavaMethodQuerySpecificationrManager INSTANCE = new JavaMethodQuerySpecificationrManager();
    private static final String JAVA_METHOD_QUERY_SPECIFICATIONS_EXTENSION_POINT = "javaMethodQuerySpecifications";
    private Map<String, IJavaMethodQuerySpecification> querySpecificationById = null;

    public static JavaMethodQuerySpecificationrManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addJavaMethodFilter(this.querySpecificationById, cf);
        }
    }

    private synchronized void addJavaMethodFilter(Map<String, IJavaMethodQuerySpecification> querySpecificationById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (QUERY_SPECIFICATION_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    Object o = ce.createExecutableExtension(CLASS_ATTR);
                    IJavaMethodQuerySpecification querySpecification = JavaMethodQuerySpecification.newJavaMethodQuerySpecification(o);
                    querySpecificationById.put(id, querySpecification);
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load javaMethodQuerySpecification for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IJavaMethodQuerySpecification getQuerySpecification(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (this.querySpecificationById == null) {
            this.loadQuerySpecifications();
        }
        return this.querySpecificationById.get(id);
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationById != null) {
            return;
        }
        HashMap<String, IJavaMethodQuerySpecification> querySpecificationById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", JAVA_METHOD_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationById = new HashMap(cf.length);
            this.addJavaMethodFilter(querySpecificationById, cf);
        } else {
            querySpecificationById = new HashMap<String, IJavaMethodQuerySpecification>();
        }
        this.querySpecificationById = querySpecificationById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return JAVA_METHOD_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

