/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.references.validators;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.validation.IMultiValidationResult;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;
import org.eclipse.wst.xml.search.editor.validation.LocalizedMessage;
import org.eclipse.wst.xml.search.editor.validation.ValidatorUtils;
import org.w3c.dom.Node;

public class DefaultDOMNodeValidator
implements IXMLReferenceValidator {
    public static final IXMLReferenceValidator INSTANCE = new DefaultDOMNodeValidator();

    @Override
    public void validate(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        if (reference != null && reference.getTo().size() > 0) {
            this.doValidate(reference, node, file, validator, reporter, batchMode);
        }
    }

    private int getStartOffset(IDOMNode node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((IDOMAttr)node).getValueRegionStartOffset();
            }
        }
        return node.getStartOffset();
    }

    protected int getSeverity(IXMLReference reference, int nbElements, IFile file, IDOMNode node) {
        return ValidatorUtils.getSeverity(reference, nbElements);
    }

    protected String getMessageText(IXMLReference reference, int nbElements, String textContent, Node node, IFile file) {
        if (textContent == null) {
            return null;
        }
        return ValidatorUtils.getMessageText(reference, nbElements, textContent, node, file);
    }

    protected String getMessageText(IXMLReference reference, int nbElements, Node node, String textContent) {
        if (textContent == null) {
            return null;
        }
        return ValidatorUtils.getMessageText(reference, nbElements, textContent);
    }

    protected LocalizedMessage createMessage(int start, int length, String messageText, int severity, IStructuredDocument structuredDocument) {
        return ValidatorUtils.createMessage(start, length, messageText, severity, structuredDocument);
    }

    protected void doValidate(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        String textContent;
        String messageText;
        if (reference.isExpression()) {
            IXMLReferenceToExpression expression = (IXMLReferenceToExpression)reference;
            IXMLSearcher searcher = expression.getSearcher();
            if (searcher != null) {
                try {
                    IValidationResult result = searcher.searchForValidation(node, DOMUtils.getNodeValue((Node)node), -1, -1, file, expression);
                    if (result != null) {
                        IMultiValidationResult multiResult = (IMultiValidationResult)result;
                        List<IValidationResult> result2 = multiResult.getResults();
                        for (IValidationResult r : result2) {
                            String messageText2;
                            int nbElements = r.getNbElements();
                            if (nbElements == 1 || (messageText2 = this.getMessageText(reference, nbElements, r.getValue(), (Node)node, file)) == null) continue;
                            int severity = this.getSeverity(reference, nbElements, file, node);
                            int startOffset = this.getStartOffset(node) + r.getStartIndex() + 1;
                            int length = r.getValue().length();
                            this.addMessage(node, file, validator, reporter, batchMode, messageText2, severity, startOffset, length);
                        }
                    }
                }
                catch (Throwable e) {
                    Trace.trace((byte)3, e.getMessage(), e);
                }
            }
            return;
        }
        int nonNegativeElements = 0;
        for (IXMLReferenceTo referenceTo : reference.getTo()) {
            IXMLSearcher searcher = referenceTo.getSearcher();
            if (searcher == null) continue;
            try {
                IValidationResult result = searcher.searchForValidation(node, DOMUtils.getNodeValue((Node)node), -1, -1, file, referenceTo);
                if (result == null) continue;
                if (result.getNbElements() < 0) {
                    String textContent2 = DOMUtils.getNodeValue((Node)node);
                    String messageText3 = this.getMessageText(reference, result.getNbElements(), textContent2, (Node)node, file);
                    if (messageText3 != null) {
                        int severity = this.getSeverity(reference, result.getNbElements(), file, node);
                        int startOffset = this.getStartOffset(node);
                        int length = textContent2.trim().length() + 2;
                        this.addMessage(node, file, validator, reporter, batchMode, messageText3, severity, startOffset, length);
                    }
                    return;
                }
                if (result.getNbElements() <= 0) continue;
                nonNegativeElements += result.getNbElements();
            }
            catch (Throwable e) {
                Trace.trace((byte)3, e.getMessage(), e);
            }
        }
        if (nonNegativeElements != 1 && (messageText = this.getMessageText(reference, nonNegativeElements, textContent = DOMUtils.getNodeValue((Node)node), (Node)node, file)) != null) {
            int severity = this.getSeverity(reference, nonNegativeElements, file, node);
            int startOffset = this.getStartOffset(node);
            int length = textContent.trim().length() + 2;
            this.addMessage(node, file, validator, reporter, batchMode, messageText, severity, startOffset, length);
        }
    }

    private void addMessage(IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode, String messageText, int severity, int startOffset, int length) {
        LocalizedMessage message = this.createMessage(startOffset, length, messageText, severity, node.getStructuredDocument());
        if (message != null) {
            if (batchMode) {
                message.setTargetObject(file);
                reporter.addMessage(validator, (IMessage)message);
            } else {
                AnnotationInfo info = new AnnotationInfo((IMessage)message);
                ((IncrementalReporter)reporter).addAnnotationInfo(validator, info);
            }
        }
    }
}

