/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;

public class SearcherToken {
    public static final SearcherToken[] EMPTY = new SearcherToken[0];
    private final String tokenId;
    private final int startOffset;
    private final int endOffset;
    private final String realMatchingString;
    private final String beforeText;
    private final String endText;
    private final List<IXMLReferenceTo> tos;

    public SearcherToken(String tokenId, String realMatchingString, String beforeText, String endText) {
        this.tokenId = tokenId;
        this.realMatchingString = realMatchingString;
        this.beforeText = beforeText;
        this.endText = endText;
        this.tos = new ArrayList<IXMLReferenceTo>();
        this.startOffset = beforeText.length();
        this.endOffset = this.startOffset + realMatchingString.length();
    }

    public SearcherToken(String tokenId, String realMatchingString, int startOffsetOfStartToken) {
        this.tokenId = tokenId;
        this.realMatchingString = realMatchingString;
        this.beforeText = null;
        this.endText = null;
        this.tos = new ArrayList<IXMLReferenceTo>();
        this.startOffset = startOffsetOfStartToken;
        this.endOffset = this.startOffset + realMatchingString.length();
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public List<IXMLReferenceTo> getTos() {
        return this.tos;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getRealMatchingString() {
        return this.realMatchingString;
    }

    public String getBeforeText() {
        return this.beforeText;
    }

    public String getEndText() {
        return this.endText;
    }
}

