/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.search.core.resource.IResourceCollector;
import org.eclipse.wst.xml.search.core.resource.IURIResolver;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;

public class ContentAssisitCollectorForResource<T>
implements IResourceCollector {
    private final T selectedNode;
    private IContentAssistProposalRecorder recorder;
    private final IContentAssistAdditionalProposalInfoProvider<IResource> provider;

    public ContentAssisitCollectorForResource(T selectedNode, IContentAssistProposalRecorder recorder, IContentAssistAdditionalProposalInfoProvider<IResource> provider) {
        this.selectedNode = selectedNode;
        this.recorder = recorder;
        this.provider = provider;
    }

    public boolean add(IResource file, IResource rootContainer, IURIResolver resolver) {
        String value;
        Image image = null;
        int relevance = 1000;
        String displayText = value = resolver.resolve(this.selectedNode, rootContainer, file);
        String replaceText = value;
        String proposedObject = null;
        if (this.provider != null) {
            String newDisplayText = this.provider.getDisplayText(displayText, file);
            if (!StringUtils.isEmpty((String)newDisplayText)) {
                displayText = newDisplayText;
            }
            image = this.provider.getImage(file);
            proposedObject = this.provider.getTextInfo(file);
        }
        this.recorder.recordProposal(image, relevance, displayText, replaceText, proposedObject);
        return true;
    }
}

