/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.sonatype.tycho.m2e.internal.PDEProjectHelper;

public class PDEMavenBundlePluginConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        List executions = this.getMojoExecutions(request, monitor);
        if (executions.size() > 1) {
            ArrayList<MavenProblemInfo> errors = new ArrayList<MavenProblemInfo>();
            for (MojoExecution mojoExecution : executions) {
                SourceLocation location = SourceLocationHelper.findLocation((Plugin)mojoExecution.getPlugin(), (String)"executions");
                MavenProblemInfo problem = new MavenProblemInfo("Duplicate " + mojoExecution.getGoal() + " executions found. Please remove any explicitly defined " + mojoExecution.getGoal() + " executions in your pom.xml.", 2, location);
                errors.add(problem);
            }
            this.markerManager.addErrorMarkers((IResource)request.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", errors);
        }
        IProject project = request.getProject();
        IMavenProjectFacade facade = request.getMavenProjectFacade();
        IPath metainfPath = this.getMetainfPath(facade, executions, monitor);
        PDEProjectHelper.addPDENature(project, metainfPath, monitor);
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        for (IClasspathEntryDescriptor entry : classpath.getEntryDescriptors()) {
            if (!"org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER".equals(entry.getPath().segment(0))) continue;
            entry.setExported(true);
        }
    }

    private IPath getMetainfPath(IMavenProjectFacade facade, List<MojoExecution> executions, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        for (MojoExecution execution : executions) {
            MavenProject mavenProject = facade.getMavenProject(monitor);
            File location = (File)maven.getMojoParameterValue(mavenProject, execution, "manifestLocation", File.class, monitor);
            if (location == null) continue;
            return facade.getProjectRelativePath(location.getAbsolutePath());
        }
        return null;
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }
}

