/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.rcp;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.coordinates.ProjectCoordinateAdvisorService;
import org.eclipse.recommenders.coordinates.rcp.CoordinateEvents;
import org.eclipse.recommenders.internal.coordinates.rcp.AdvisorDescriptor;
import org.eclipse.recommenders.internal.coordinates.rcp.AdvisorDescriptors;
import org.eclipse.recommenders.internal.coordinates.rcp.CoordinatesRcpPreferences;
import org.eclipse.recommenders.internal.coordinates.rcp.DependencyInfoJsonTypeAdapter;
import org.eclipse.recommenders.internal.coordinates.rcp.ProjectCoordinateJsonTypeAdapter;
import org.eclipse.recommenders.internal.coordinates.rcp.l10n.LogMessages;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.recommenders.utils.gson.OptionalJsonTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseProjectCoordinateAdvisorService
extends AbstractIdleService
implements IProjectCoordinateAdvisorService,
IRcpService {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseProjectCoordinateAdvisorService.class);
    private static final Type CACHE_TYPE_TOKEN = new TypeToken<Map<DependencyInfo, Optional<ProjectCoordinate>>>(){}.getType();
    private final ProjectCoordinateAdvisorService delegate;
    private final CoordinatesRcpPreferences prefs;
    private final LoadingCache<DependencyInfo, Optional<ProjectCoordinate>> projectCoordinateCache;
    private final File persistenceFile;
    private final Gson cacheGson;
    private Map<IProjectCoordinateAdvisor, AdvisorDescriptor> descriptors = Maps.newHashMap();

    @Inject
    public EclipseProjectCoordinateAdvisorService(@Named(value="IDENTIFIED_PACKAGE_FRAGMENT_ROOTS") File persistenceFile, EventBus bus, CoordinatesRcpPreferences prefs) {
        bus.register((Object)this);
        this.prefs = prefs;
        this.delegate = new ProjectCoordinateAdvisorService();
        this.persistenceFile = persistenceFile;
        this.cacheGson = new GsonBuilder().registerTypeAdapter(ProjectCoordinate.class, (Object)new ProjectCoordinateJsonTypeAdapter()).registerTypeAdapter(DependencyInfo.class, (Object)new DependencyInfoJsonTypeAdapter()).registerTypeAdapter(Optional.class, (Object)new OptionalJsonTypeAdapter()).enableComplexMapKeySerialization().serializeNulls().create();
        this.projectCoordinateCache = this.createCache();
    }

    private LoadingCache<DependencyInfo, Optional<ProjectCoordinate>> createCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<DependencyInfo, Optional<ProjectCoordinate>>(){

            public Optional<ProjectCoordinate> load(DependencyInfo info) {
                return EclipseProjectCoordinateAdvisorService.this.delegate.suggest(info);
            }
        });
    }

    public ImmutableList<IProjectCoordinateAdvisor> getAdvisors() {
        return this.delegate.getAdvisors();
    }

    public void addAdvisor(IProjectCoordinateAdvisor advisor) {
        this.delegate.addAdvisor(advisor);
    }

    public void setAdvisors(List<IProjectCoordinateAdvisor> advisors) {
        this.delegate.setAdvisors(advisors);
    }

    public AdvisorDescriptor getDescriptor(IProjectCoordinateAdvisor advisor) {
        return this.descriptors.get(advisor);
    }

    public Optional<ProjectCoordinate> suggest(DependencyInfo dependencyInfo) {
        try {
            this.awaitRunning();
            return (Optional)this.projectCoordinateCache.get((Object)dependencyInfo);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_IN_ADVISOR_SERVICE_SUGGEST, (Throwable)e, (Object[])new Object[]{dependencyInfo.toString()});
            return Optional.absent();
        }
    }

    public Result<ProjectCoordinate> trySuggest(DependencyInfo dependencyInfo) {
        Optional pc = (Optional)this.projectCoordinateCache.getIfPresent((Object)dependencyInfo);
        if (pc == null) {
            return Result.absent((int)1);
        }
        if (pc.isPresent()) {
            return Result.of((Object)((ProjectCoordinate)pc.get()));
        }
        return Result.absent();
    }

    @PostConstruct
    public void open() {
        this.startAsync();
    }

    protected void startUp() {
        Map deserializedCache;
        this.configureAdvisorList(this.prefs.advisorConfiguration);
        if (!this.persistenceFile.exists()) {
            return;
        }
        try {
            String json = Files.toString((File)this.persistenceFile, (Charset)Charsets.UTF_8);
            deserializedCache = (Map)this.cacheGson.fromJson(json, CACHE_TYPE_TOKEN);
        }
        catch (JsonParseException | IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_CACHED_COORDINATES, (Throwable)e, (Object[])new Object[]{this.persistenceFile});
            return;
        }
        if (deserializedCache == null) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_CACHED_COORDINATES, (Object[])new Object[]{this.persistenceFile});
            return;
        }
        this.projectCoordinateCache.putAll(deserializedCache);
    }

    private void configureAdvisorList(String advisorConfiguration) {
        this.setAdvisors(this.provideAdvisors(advisorConfiguration));
    }

    private List<IProjectCoordinateAdvisor> provideAdvisors(String advisorConfiguration) {
        HashMap newDescriptors = Maps.newHashMap();
        List<AdvisorDescriptor> registeredAdvisors = AdvisorDescriptors.getRegisteredAdvisors();
        List<AdvisorDescriptor> loadedDescriptors = AdvisorDescriptors.load(advisorConfiguration, registeredAdvisors);
        ArrayList advisors = Lists.newArrayListWithCapacity((int)loadedDescriptors.size());
        for (AdvisorDescriptor descriptor : loadedDescriptors) {
            try {
                if (!descriptor.isEnabled()) continue;
                IProjectCoordinateAdvisor advisor = descriptor.createAdvisor();
                advisors.add(advisor);
                newDescriptors.put(advisor, descriptor);
            }
            catch (CoreException e) {
                LOG.error("Exception during creation of advisor {}.", (Object)descriptor.getId(), (Object)e);
            }
        }
        this.descriptors = newDescriptors;
        return advisors;
    }

    @PreDestroy
    public void close() {
        this.stopAsync();
    }

    protected void shutDown() {
        try {
            String json = this.cacheGson.toJson((Object)this.projectCoordinateCache.asMap(), CACHE_TYPE_TOKEN);
            Files.write((CharSequence)json, (File)this.persistenceFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_WRITE_CACHED_COORDINATES, (Throwable)e, (Object[])new Object[]{this.persistenceFile});
            FileUtils.deleteQuietly((File)this.persistenceFile);
        }
    }

    @Subscribe
    public void onEvent(CoordinateEvents.ProjectCoordinateChangeEvent e) {
        this.projectCoordinateCache.invalidate((Object)e.dependencyInfo);
    }

    @Subscribe
    public void onEvent(CoordinateEvents.AdvisorConfigurationChangedEvent e) {
        this.clearCache();
        this.configureAdvisorList(this.prefs.advisorConfiguration);
    }

    public void clearCache() {
        this.projectCoordinateCache.invalidateAll();
    }
}

