/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.outline;

import java.util.ArrayList;
import java.util.List;
import tern.utils.StringUtils;

public class JSNode {
    private static final String FN_TYPE = "fn(";
    private static final String ARRAY_TYPE = "[";
    private final String name;
    private final String type;
    private final String kind;
    private final Long start;
    private final Long end;
    private final String file;
    private final JSNode parent;
    private final List<JSNode> children;
    private final boolean isClass;
    private final boolean isFunction;
    private final boolean isArray;

    public JSNode(String name, String type, String kind, Long start, Long end, String file, JSNode parent) {
        this.name = name;
        this.type = type;
        this.start = start;
        this.end = end;
        this.file = file;
        this.children = new ArrayList<JSNode>();
        if (parent != null) {
            this.parent = parent;
            parent.addChild(this);
        } else {
            this.parent = null;
        }
        if (type != null) {
            this.isFunction = type.startsWith(FN_TYPE);
            this.isArray = type.startsWith(ARRAY_TYPE);
        } else {
            this.isFunction = false;
            this.isArray = false;
        }
        this.kind = kind;
        this.isClass = kind != null ? "class".equals(kind) : false;
    }

    public String getName() {
        return StringUtils.isEmpty(this.file) ? this.name : this.file;
    }

    public String getType() {
        return this.type;
    }

    public String getKind() {
        return this.kind;
    }

    public List<JSNode> getChildren() {
        return this.children;
    }

    public boolean hasChidren() {
        return this.children.size() > 0;
    }

    public JSNode getParent() {
        return this.parent;
    }

    public void addChild(JSNode node) {
        this.children.add(node);
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isFile() {
        return !StringUtils.isEmpty(this.file);
    }
}

