/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.model.IBaseModel;
import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.IModelChangedListener;
import com.liferay.ide.portlet.core.PluginPackageModel;
import com.liferay.ide.portlet.ui.editor.PluginPackageEditor;
import com.liferay.ide.portlet.ui.editor.PortalJarViewerFilter;
import com.liferay.ide.ui.form.DefaultContentProvider;
import com.liferay.ide.ui.form.EditableTablePart;
import com.liferay.ide.ui.form.FormLayoutFactory;
import com.liferay.ide.ui.form.IDEFormPage;
import com.liferay.ide.ui.form.TableSection;
import com.liferay.ide.ui.wizard.ExternalFileSelectionDialog;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PortalJarsSection
extends TableSection
implements IModelChangedListener,
IPropertyChangeListener {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int UP_INDEX = 2;
    private static final int DOWN_INDEX = 3;
    private TableViewer fViewer;
    private Vector<File> fJars;
    private Action fAddAction;
    private Action fRemoveAction;

    protected void createJarsArray() {
        this.fJars = new Vector();
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        String[] portalJars = model.getPortalDependencyJars();
        IPath portalDir = ((PluginPackageEditor)this.getPage().getEditor()).getPortalDir();
        if (portalDir != null) {
            String[] stringArray = portalJars;
            int n = portalJars.length;
            int n2 = 0;
            while (n2 < n) {
                String portalJar = stringArray[n2];
                File jarFile = new File(portalDir.append("WEB-INF/lib").toFile(), portalJar.trim());
                if (jarFile.isFile() && jarFile.exists()) {
                    this.fJars.add(jarFile);
                }
                ++n2;
            }
        }
    }

    public PortalJarsSection(IDEFormPage page, Composite parent, String[] labels) {
        super(page, parent, 128, labels);
        this.getSection().setText(Msgs.portalDependencyJars);
        this.getSection().setDescription(Msgs.specifyJars);
        this.getSection().getTextClient().getParent().layout(true);
        this.getTablePart().setEditable(true);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fViewer = tablePart.getTableViewer();
        this.fViewer.setContentProvider((IContentProvider)new PortalJarsContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new PortalJarsLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 250;
        gd.grabExcessVerticalSpace = true;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setLayoutData((Object)gd);
        section.setText(Msgs.portalDependencyJars);
        this.createSectionToolbar(section, toolkit);
        this.initialize();
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getFormEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        this.updateUpDownButtons();
        tablePart.setButtonEnabled(1, this.isEditable() && hasSelection);
    }

    private void updateUpDownButtons() {
        EditableTablePart tablePart = this.getTablePart();
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1 && selection.length == 1;
        tablePart.setButtonEnabled(2, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    public void dispose() {
        IBaseModel model = this.getPage().getModel();
        if (model != null) {
            model.dispose();
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fViewer.getSelection();
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        int i = 0;
        String[] removedFiles = new String[ssel.size()];
        Iterator iter = ssel.iterator();
        while (iter.hasNext()) {
            removedFiles[i] = ((File)iter.next()).getName();
            ++i;
        }
        model.removePortalDependencyJars(removedFiles);
        this.updateButtons();
    }

    private void handleAdd() {
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        String[] existingJars = model.getPortalDependencyJars();
        PluginPackageEditor editor = (PluginPackageEditor)this.getPage().getEditor();
        IPath portalDir = editor.getPortalDir();
        if (portalDir != null) {
            ExternalFileSelectionDialog dialog = new ExternalFileSelectionDialog(this.getPage().getShell(), (ViewerFilter)new PortalJarViewerFilter(portalDir.toFile(), new String[]{"WEB-INF", "WEB-INF/lib"}, existingJars), true, false);
            dialog.setInput((Object)portalDir.toFile());
            dialog.create();
            if (dialog.open() == 0) {
                Object[] selectedFiles = dialog.getResult();
                try {
                    int i = 0;
                    while (i < selectedFiles.length) {
                        File jar = (File)selectedFiles[i];
                        if (jar.exists()) {
                            model.addPortalDependencyJar(jar.getName());
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            MessageDialog.openInformation((Shell)this.getPage().getShell(), (String)Msgs.liferayPluginPackageEditor, (String)Msgs.notDeterminePortalDirectory);
        }
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    public void swap(int index1, int index2) {
    }

    public void initialize() {
        PluginPackageModel model = (PluginPackageModel)this.getPage().getModel();
        if (model == null) {
            return;
        }
        this.fViewer.setInput((Object)model);
        this.updateButtons();
        model.addModelChangedListener((IModelChangedListener)this);
        this.fAddAction.setEnabled(model.isEditable());
        this.fRemoveAction.setEnabled(model.isEditable());
    }

    private void makeActions() {
        this.fAddAction = new Action(Msgs.add){

            public void run() {
                PortalJarsSection.this.handleAdd();
            }
        };
        this.fRemoveAction = new Action(Msgs.remove){

            public void run() {
                PortalJarsSection.this.handleRemove();
            }
        };
    }

    public void refresh() {
        this.fJars = null;
        this.fViewer.refresh();
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (event.getChangedProperty() == "portal-dependency-jars") {
            this.refresh();
            this.updateButtons();
            return;
        }
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getTable().setFocus();
        }
    }

    protected boolean createCount() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected boolean isDragAndDropEnabled() {
        return false;
    }

    private static class Msgs
    extends NLS {
        public static String add;
        public static String liferayPluginPackageEditor;
        public static String notDeterminePortalDirectory;
        public static String portalDependencyJars;
        public static String remove;
        public static String specifyJars;

        static {
            Msgs.initializeMessages((String)PortalJarsSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    class PortalJarsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PortalJarsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (PortalJarsSection.this.fJars == null) {
                PortalJarsSection.this.createJarsArray();
            }
            return PortalJarsSection.this.fJars.toArray();
        }
    }

    class PortalJarsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PortalJarsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof File) {
                File file = (File)element;
                return file.getName();
            }
            return "";
        }
    }
}

