/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.ServerTypeProxy;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class ServerTypeTreeContentProvider
extends AbstractTreeContentProvider {
    protected boolean localhost = true;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected boolean includeIncompatibleVersions;

    public ServerTypeTreeContentProvider(IModuleType moduleType, String serverTypeId) {
        super(false);
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                block5: {
                    IServerType serverType = serverTypes[i];
                    if (this.include(serverType)) {
                        try {
                            IRuntimeType runtimeType = serverType.getRuntimeType();
                            AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                            ele.contents.add(serverType);
                            this.elementToParentMap.put(serverType, ele);
                        }
                        catch (Exception e) {
                            if (!Trace.WARNING) break block5;
                            Trace.trace("/warning", "Error in server configuration content provider", e);
                        }
                    }
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }

    public void cleanAdapterTree(final TreeViewer treeViewer) {
        this.fillTree();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    treeViewer.refresh((Object)"root");
                }
                catch (Exception exception) {}
            }
        });
    }

    protected boolean include(IServerType serverType) {
        IRuntimeType runtimeType;
        if (serverType instanceof ServerTypeProxy) {
            return true;
        }
        if (this.serverTypeId != null && !serverType.getId().startsWith(this.serverTypeId)) {
            return false;
        }
        try {
            if (!((ServerType)serverType).supportsManualCreation()) {
                return false;
            }
        }
        catch (Exception exception) {}
        if ((runtimeType = serverType.getRuntimeType()) == null) {
            return false;
        }
        String moduleTypeId = null;
        if (this.moduleType != null) {
            moduleTypeId = this.moduleType.getId();
        }
        if (this.includeIncompatibleVersions) {
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, null)) {
                return false;
            }
        } else {
            String moduleVersion = null;
            if (this.moduleType != null) {
                moduleVersion = this.moduleType.getVersion();
            }
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, (String)moduleVersion)) {
                return false;
            }
        }
        return this.localhost || serverType.supportsRemoteHosts();
    }

    private boolean compareServers(List serverList, ServerTypeProxy server) {
        for (IServerType existingServer : serverList) {
            if (!existingServer.getId().equals(server.getProxyServerId())) continue;
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.wst.server.discovery", "already installed: " + server.getProxyServerId(), null));
            return true;
        }
        return false;
    }

    protected void deferredAdapterInitialize(final TreeViewer treeViewer, IProgressMonitor monitor) {
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IServerType[] serverTypes = ServerCore.getDownloadableServers((IProgressMonitor)monitor);
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                block6: {
                    IServerType serverType = serverTypes[i];
                    try {
                        IRuntimeType runtimeType = serverType.getRuntimeType();
                        AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                        if (!this.compareServers(ele.contents, (ServerTypeProxy)serverType)) {
                            ele.contents.add(serverType);
                            this.elementToParentMap.put(serverType, ele);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.WARNING) break block6;
                        Trace.trace("/warning", "Error in server configuration content provider", e);
                    }
                }
                ++i;
            }
        }
        if (list.size() > 0) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.addAll(Arrays.asList(this.elements));
            newList.addAll(list);
            this.elements = newList.toArray();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getTree().isDisposed()) {
                        treeViewer.refresh((Object)"root");
                    }
                }
            });
        }
    }

    protected boolean checkForNonStubEnvironmentRuntime(IServerType serverType) {
        IRuntimeType runtimeType = serverType.getRuntimeType();
        IRuntime[] runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (runtimes == null || runtimes.length == 0) {
            return false;
        }
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (!runtimes[i].isStub()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLocalhost(boolean local) {
        this.localhost = local;
        this.fillTree();
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        this.fillTree();
    }
}

