/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.draw2d;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ColumnFigure
extends RoundedRectangle {
    protected boolean drawText = true;
    protected String text = null;

    public ColumnFigure() {
        this.setAntialias(1);
    }

    private boolean compareFonts(Font font1, Font font2) {
        FontData[] data2;
        if (font1 == null || font2 == null) {
            return false;
        }
        if (!font1.getDevice().equals(font2.getDevice())) {
            return false;
        }
        FontData[] data1 = font1.getFontData();
        if (data1.length != (data2 = font2.getFontData()).length) {
            return false;
        }
        int i = 0;
        while (i < data1.length) {
            if (!data1[i].equals((Object)data2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void correctFont() {
        Font initialFont = this.getFont();
        if (initialFont != null && !this.getFont().isDisposed() && !this.getFont().getDevice().isDisposed()) {
            FontData[] fontData = initialFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                int height = 24;
                fontData[i].setHeight(height);
                int width = this.getFontWidth(fontData[i]);
                while (width > this.getPreferredSize().width() - 1) {
                    fontData[i].setHeight(--height);
                    width = this.getFontWidth(fontData[i]);
                }
                ++i;
            }
            Font correctedFont = new Font(this.getFont().getDevice(), fontData);
            if (!this.compareFonts(initialFont, correctedFont)) {
                this.setFont(correctedFont);
            } else {
                correctedFont.dispose();
            }
        }
    }

    protected int getFontWidth(FontData fontData) {
        Font newFont = new Font(this.getFont().getDevice(), fontData);
        int width = FigureUtilities.getTextExtents((String)this.getText(), (Font)newFont).width();
        newFont.dispose();
        return width;
    }

    public String getText() {
        return this.text;
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.getText() == null) {
            return;
        }
        if (!this.shouldDrawText()) {
            return;
        }
        this.correctFont();
        if (graphics.getFont() != null) {
            graphics.setTextAntialias(1);
            graphics.setFont(this.getFont());
            Dimension extent = FigureUtilities.getTextExtents((String)this.getText(), (Font)graphics.getFont());
            graphics.drawString(this.getText(), this.bounds.x + this.bounds.width / 2 - extent.width / 2, this.bounds.y + this.bounds.height / 2 - extent.height / 2);
        }
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean shouldDrawText() {
        return this.drawText;
    }
}

