/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.sections;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11MessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.NameSection;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;

public class W11MessageReferenceSection
extends NameSection {
    protected CLabel comboLabel;
    protected CCombo combo;
    protected ComponentReferenceEditManager refManager;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.createControlArea();
    }

    public void createControlArea() {
        this.comboLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_MESSAGE);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.comboLabel.setLayoutData((Object)data);
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        this.combo.setBackground(this.composite.getBackground());
        this.combo.addListener(24, (Listener)this);
        this.combo.addListener(14, (Listener)this);
        this.combo.addListener(31, (Listener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_MESSAGE_REF_MESSAGE_COMBO);
        this.combo.setLayoutData((Object)new GridData(768));
    }

    public void refresh() {
        int index;
        ComponentReferenceEditManager editManager;
        super.refresh();
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        String refName = "";
        this.combo.removeAll();
        this.combo.add(BROWSE_STRING);
        this.combo.add(NEW_STRING);
        MessageReference messageRef = (MessageReference)((W11MessageReference)this.getModel()).getTarget();
        if (messageRef != null && messageRef.getEMessage() != null) {
            refName = messageRef.getEMessage().getQName().getLocalPart();
        }
        if ((editManager = this.getComponentReferenceEditManager()) != null) {
            ComponentSpecification[] specs = editManager.getQuickPicks();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
        }
        String[] items = this.combo.getItems();
        index = 0;
        while (index < items.length) {
            if (items[index].equals(refName)) break;
            ++index;
        }
        if (index < items.length) {
            this.combo.select(index);
        } else {
            this.combo.setText(refName);
        }
        this.setControlForegroundColor((Control)this.combo);
        this.setListenerEnabled(true);
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        if (this.refManager != null) {
            return this.refManager;
        }
        this.refManager = ReferenceEditManagerHelper.getMessageReferenceEditManager((IASDObject)this.getModel());
        return this.refManager;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.combo) {
            if (this.isListenerEnabled() && !this.isInDoHandle) {
                if (event.type == 31) {
                    if (event.detail == 64 || event.detail == 32) {
                        this.isTraversing = true;
                    }
                } else {
                    this.isInDoHandle = true;
                    this.startDelayedEvent(event);
                    this.isInDoHandle = false;
                }
            }
        } else {
            super.handleEvent(event);
        }
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.combo) {
            String value = "";
            if (this.combo.getSelectionIndex() != -1) {
                value = this.combo.getItem(this.combo.getSelectionIndex());
            }
            if (this.shouldPerformComboSelection(event, value)) {
                ComponentReferenceEditManager editManager;
                ComponentSpecification spec = null;
                int continueApply = 0;
                IMessageReference messageRef = (IMessageReference)this.getModel();
                if (value.equals(NEW_STRING)) {
                    editManager = this.getComponentReferenceEditManager();
                    IComponentDialog dialog = editManager.getNewDialog();
                    continueApply = dialog.createAndOpen();
                    spec = dialog.getSelectedComponent();
                } else if (value.equals(BROWSE_STRING)) {
                    editManager = this.getComponentReferenceEditManager();
                    IComponentDialog dialog = editManager.getBrowseDialog();
                    continueApply = dialog.createAndOpen();
                    spec = dialog.getSelectedComponent();
                } else {
                    spec = this.getComponentSpecificationForValue(value);
                }
                if (continueApply == 0) {
                    editManager = this.getComponentReferenceEditManager();
                    if (spec != null) {
                        editManager.modifyComponentReference((Object)messageRef, spec);
                    }
                }
            }
        }
    }

    protected ComponentSpecification getComponentSpecificationForValue(String value) {
        ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] history;
            ComponentSpecification[] quickPicks = editManager.getQuickPicks();
            if (quickPicks != null) {
                int i = 0;
                while (i < quickPicks.length) {
                    ComponentSpecification componentSpecification = quickPicks[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
            if ((history = editManager.getHistory()) != null) {
                int i = 0;
                while (i < history.length) {
                    ComponentSpecification componentSpecification = history[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public void dispose() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeListener(24, (Listener)this);
            this.combo.removeListener(14, (Listener)this);
            this.combo.removeListener(31, (Listener)this);
        }
        super.dispose();
    }
}

