/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class MigrationUtil {
    public static IResource getIResourceFromProblem(Problem problem) {
        IFile[] files;
        IFile retval = null;
        IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(problem.file.toURI());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.exists()) {
                if (CoreUtil.isLiferayProject((IProject)file.getProject())) {
                    retval = file;
                    break;
                }
                if (retval == null) {
                    retval = file;
                } else if (file.getFullPath().segmentCount() < retval.getFullPath().segmentCount()) {
                    retval = file;
                }
            } else {
                IPath path = file.getFullPath();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(path.segmentCount() - 1));
                if (project.exists()) {
                    retval = project;
                }
            }
            ++n2;
        }
        return retval;
    }

    public static List<Problem> getResolvedProblemsFromResource(IResource resource) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("com.liferay.ide.project.core.MigrationProblemMarker", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Problem problem = MigrationUtil.markerToProblem(marker);
                if (problem != null && problem.getStatus() == 1) {
                    problems.add(problem);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return problems;
    }

    public static Problem getProblemFromSelection(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Problem) {
            return (Problem)element;
        }
        return null;
    }

    public static List<Problem> getProblemsFromSelection(ISelection selection) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss) {
                if (!(element instanceof Problem)) continue;
                problems.add((Problem)element);
            }
        }
        return problems;
    }

    public static List<Problem> getProblemsFromResource(IResource resource) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("com.liferay.ide.project.core.MigrationProblemMarker", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Problem problem = MigrationUtil.markerToProblem(marker);
                if (problem != null) {
                    problems.add(problem);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return problems;
    }

    public static List<Problem> getProblemsFromTreeNode(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof FileProblems) {
            FileProblems fp = (FileProblems)element;
            return fp.getProblems();
        }
        return null;
    }

    public static Problem markerToProblem(IMarker marker) {
        String title = marker.getAttribute("message", "");
        String summary = marker.getAttribute("migrationProblem.summary", "");
        String type = marker.getAttribute("migrationProblem.type", "");
        String ticket = marker.getAttribute("migrationProblem.ticket", "");
        int lineNumber = marker.getAttribute("lineNumber", 0);
        int startOffset = marker.getAttribute("charStart", 0);
        int endOffset = marker.getAttribute("charEnd", 0);
        String html = marker.getAttribute("migrationProblem.html", "");
        String autoCorrectContext = marker.getAttribute("migrationProblem.autoCorrectContext", "");
        int status = marker.getAttribute("migrationProblem.status", 0);
        long markerId = marker.getId();
        File file = new File(marker.getResource().getLocationURI());
        return new Problem(title, summary, type, ticket, file, lineNumber, startOffset, endOffset, html, autoCorrectContext, status, markerId);
    }

    public static void openEditor(Problem Problem2) {
        try {
            IEditorPart editor;
            IResource resource = MigrationUtil.getIResourceFromProblem(Problem2);
            if (resource instanceof IFile && (editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource))) instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(Problem2.startOffset, Problem2.endOffset - Problem2.startOffset);
            }
        }
        catch (PartInitException partInitException) {}
    }

    public static void problemToMarker(Problem problem, IMarker marker) throws CoreException {
        marker.setAttribute("message", (Object)problem.title);
        marker.setAttribute("migrationProblem.summary", (Object)problem.summary);
        marker.setAttribute("migrationProblem.type", (Object)problem.type);
        marker.setAttribute("migrationProblem.ticket", (Object)problem.ticket);
        marker.setAttribute("lineNumber", problem.lineNumber);
        marker.setAttribute("charStart", problem.startOffset);
        marker.setAttribute("charEnd", problem.endOffset);
        marker.setAttribute("migrationProblem.status", problem.status);
        marker.setAttribute("migrationProblem.html", (Object)problem.html);
        marker.setAttribute("migrationProblem.autoCorrectContext", (Object)problem.getAutoCorrectContext());
        marker.setAttribute("location", (Object)problem.file.getName());
        marker.setAttribute("severity", 2);
    }
}

