/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.MigrationListener;
import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class WorkspaceMigrationImpl
implements MigrationListener {
    public void problemsFound(List<Problem> problems) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        for (Problem problem : problems) {
            IContainer workspaceResource = null;
            File file = problem.file;
            IContainer[] containers = ws.findContainersForLocationURI(file.toURI());
            if (containers != null && containers.length > 0) {
                IContainer container;
                IContainer[] iContainerArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    container = iContainerArray[n2];
                    if (container.exists()) {
                        if (container.getType() == 4) {
                            workspaceResource = container;
                            break;
                        }
                        IProject project = container.getProject();
                        if (CoreUtil.isLiferayProject((IProject)project)) {
                            workspaceResource = container;
                            break;
                        }
                    }
                    ++n2;
                }
                if (workspaceResource == null) {
                    IFile[] files;
                    IFile[] iFileArray = files = ws.findFilesForLocationURI(file.toURI());
                    int n3 = files.length;
                    n = 0;
                    while (n < n3) {
                        IFile ifile = iFileArray[n];
                        if (ifile.exists() && CoreUtil.isLiferayProject((IProject)ifile.getProject())) {
                            workspaceResource = ifile;
                            break;
                        }
                        ++n;
                    }
                }
                if (workspaceResource == null) {
                    iContainerArray = containers;
                    n = containers.length;
                    int n4 = 0;
                    while (n4 < n) {
                        container = iContainerArray[n4];
                        if (workspaceResource == null) {
                            workspaceResource = container;
                        } else if (container.getLocation().segmentCount() < workspaceResource.getLocation().segmentCount()) {
                            workspaceResource = container;
                        }
                        ++n4;
                    }
                }
            }
            if (workspaceResource == null || !workspaceResource.exists()) continue;
            try {
                if (!this.shouldAddMarker((IResource)workspaceResource)) continue;
                IMarker marker = workspaceResource.createMarker("com.liferay.ide.project.core.MigrationProblemMarker");
                MigrationUtil.problemToMarker(problem, marker);
            }
            catch (CoreException coreException) {}
        }
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                UIUtil.showView((String)"com.liferay.ide.project.ui.migrationView");
            }
        });
    }

    private boolean shouldAddMarker(IResource resource) {
        return !resource.getFullPath().toString().contains("WEB-INF/classes");
    }
}

