/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.blade.api.Command;
import com.liferay.blade.api.CommandException;
import com.liferay.ide.project.core.upgrade.Liferay7UpgradeAssistantSettings;
import com.liferay.ide.project.core.upgrade.PortalSettings;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.AbstractOSGiCommandHandler;
import com.liferay.ide.project.ui.upgrade.GetPortalSettingsOp;
import com.liferay.ide.project.ui.upgrade.GetPortalSettingsWizard;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.modeling.Path;

public class CopyPortalSettingsHandler
extends AbstractOSGiCommandHandler {
    public CopyPortalSettingsHandler() {
        super("copyPortalSettings");
    }

    @Override
    protected Object execute(ExecutionEvent event, final Command command) throws ExecutionException {
        try {
            Liferay7UpgradeAssistantSettings settings = (Liferay7UpgradeAssistantSettings)UpgradeAssistantSettingsUtil.getObjectFromStore(Liferay7UpgradeAssistantSettings.class);
            if (settings == null || settings.getPortalSettings() == null) {
                GetPortalSettingsWizard wizard = new GetPortalSettingsWizard();
                int retcode = new WizardDialog(UIUtil.getActiveShell(), (IWizard)wizard).open();
                if (retcode == 0) {
                    String previousLocation = ((Path)((GetPortalSettingsOp)wizard.element()).getPreviousLiferayLocation().content()).toOSString();
                    String newName = (String)((GetPortalSettingsOp)wizard.element()).getNewLiferayName().content();
                    String newLocation = ((Path)((GetPortalSettingsOp)wizard.element()).getNewLiferayLocation().content()).toOSString();
                    PortalSettings portalSettings = settings.getPortalSettings();
                    if (portalSettings == null) {
                        portalSettings = new PortalSettings();
                    }
                    portalSettings.setPreviousLiferayPortalLocation(previousLocation);
                    portalSettings.setNewName(newName);
                    portalSettings.setNewLiferayPortalLocation(newLocation);
                    settings.setPortalSettings(portalSettings);
                }
            }
            if (settings != null) {
                PortalSettings portalSettings = settings.getPortalSettings();
                File sourceLiferayLocationDir = new File(portalSettings.getPreviousLiferayPortalLocation());
                File destLiferayLocationDir = new File(portalSettings.getNewLiferayPortalLocation());
                final HashMap<String, File> parameters = new HashMap<String, File>();
                parameters.put("source", sourceLiferayLocationDir);
                parameters.put("dest", destLiferayLocationDir);
                new Job("Copy portal settings"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            command.execute(parameters);
                        }
                        catch (CommandException e) {
                            return ProjectUI.createErrorStatus("Command failed", (Exception)((Object)e));
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                UpgradeAssistantSettingsUtil.setObjectToStore(Liferay7UpgradeAssistantSettings.class, (Object)settings);
            }
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

