/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.project.core.upgrade.Liferay7UpgradeAssistantSettings;
import com.liferay.ide.project.core.upgrade.PortalSettings;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.upgrade.GetPortalSettingsOp;
import java.io.File;
import java.io.IOException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;

public class GetPortalSettingsWizard
extends SapphireWizard<GetPortalSettingsOp> {
    public GetPortalSettingsWizard() {
        super((Element)GetPortalSettingsWizard.createDefaultOp(), DefinitionLoader.sdef(GetPortalSettingsWizard.class).wizard());
    }

    private static GetPortalSettingsOp createDefaultOp() {
        return (GetPortalSettingsOp)GetPortalSettingsOp.TYPE.instantiate();
    }

    public static final Status execute(GetPortalSettingsOp op, ProgressMonitor pm) {
        File previousLiferayLocationDir = ((Path)op.getPreviousLiferayLocation().content()).toFile();
        File newLiferayLocationDir = ((Path)op.getNewLiferayLocation().content()).toFile();
        String newName = (String)op.getNewLiferayName().content();
        try {
            PortalSettings portalSettings;
            Liferay7UpgradeAssistantSettings settings = (Liferay7UpgradeAssistantSettings)UpgradeAssistantSettingsUtil.getObjectFromStore(Liferay7UpgradeAssistantSettings.class);
            if (settings == null) {
                settings = new Liferay7UpgradeAssistantSettings();
            }
            if ((portalSettings = settings.getPortalSettings()) == null) {
                portalSettings = new PortalSettings();
            }
            portalSettings.setPreviousLiferayPortalLocation(previousLiferayLocationDir.getPath());
            portalSettings.setNewName(newName);
            portalSettings.setNewLiferayPortalLocation(newLiferayLocationDir.getPath());
            portalSettings.setType("Portal Setting");
            settings.setPortalSettings(portalSettings);
            UpgradeAssistantSettingsUtil.setObjectToStore(Liferay7UpgradeAssistantSettings.class, (Object)settings);
        }
        catch (IOException e) {
            return Status.createErrorStatus((Throwable)e);
        }
        return Status.createOkStatus();
    }
}

