/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.modules;

import com.liferay.ide.gradle.core.modules.NewJSPHookModuleOp;
import com.liferay.ide.gradle.core.modules.OSGiCustomJSP;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.wst.server.core.IRuntime;

public class OSGiCustomJSPPossibleValuesService
extends PossibleValuesService {
    private static String osgiBundleName;
    private static Set<String> possibleValues;

    protected void compute(Set<String> values) {
        NewJSPHookModuleOp op = this.op();
        String currentOSGiBundle = (String)op.getCustomOSGiBundle().content();
        if (osgiBundleName == null || !osgiBundleName.equals(currentOSGiBundle) || possibleValues == null) {
            File module;
            osgiBundleName = currentOSGiBundle;
            possibleValues = new HashSet<String>();
            String runtimeName = (String)op.getBundleName().content();
            IRuntime runtime = ServerUtil.getRuntime((String)runtimeName);
            PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
            if (portalBundle != null && (module = portalBundle.getOSGiBundlesDir().append("modules").append(currentOSGiBundle).toFile()).exists()) {
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (JarFile jar = new JarFile(module);){
                        Enumeration<JarEntry> enu = jar.entries();
                        while (enu.hasMoreElements()) {
                            JarEntry entry = enu.nextElement();
                            String name = entry.getName();
                            if (!name.startsWith("META-INF/resources/") || !name.endsWith(".jsp") && !name.endsWith(".jspf")) continue;
                            possibleValues.add(name);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (possibleValues != null) {
            HashSet<String> possibleValuesSet = new HashSet<String>();
            possibleValuesSet.addAll(possibleValues);
            ElementList<OSGiCustomJSP> currentJsps = op.getCustomJSPs();
            if (currentJsps != null) {
                for (OSGiCustomJSP cj : currentJsps) {
                    String value = (String)cj.getValue().content();
                    if (value == null) continue;
                    possibleValuesSet.remove(value);
                }
            }
            values.addAll(possibleValuesSet);
        }
    }

    public Status problem(Value<?> value) {
        return Status.createOkStatus();
    }

    private NewJSPHookModuleOp op() {
        return (NewJSPHookModuleOp)this.context(NewJSPHookModuleOp.class);
    }
}

