/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.wst.jsdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class LegacyJavadocCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final String PROCESSOR_CONTRIBUTION_ID = "javadocCompletionProcessor";
    private IJavadocCompletionProcessor[] fSubProcessors = null;
    private String fErrorMessage;

    private IJavadocCompletionProcessor[] getContributedProcessors() {
        if (this.fSubProcessors == null) {
            try {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.wst.jsdt.ui", PROCESSOR_CONTRIBUTION_ID);
                IJavadocCompletionProcessor[] result = new IJavadocCompletionProcessor[elements.length];
                int i = 0;
                while (i < elements.length) {
                    result[i] = (IJavadocCompletionProcessor)elements[i].createExecutableExtension("class");
                    ++i;
                }
                this.fSubProcessors = result;
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                this.fSubProcessors = new IJavadocCompletionProcessor[0];
            }
        }
        return this.fSubProcessors;
    }

    @Override
    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            IJavaScriptUnit cu = javaContext.getCompilationUnit();
            int offset = javaContext.getInvocationOffset();
            ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
            IJavadocCompletionProcessor[] processors = this.getContributedProcessors();
            String error = null;
            int i = 0;
            while (i < processors.length) {
                IJavadocCompletionProcessor curr = processors[i];
                IContextInformation[] contextInfos = curr.computeContextInformation(cu, offset);
                if (contextInfos != null) {
                    int k = 0;
                    while (k < contextInfos.length) {
                        result.add(contextInfos[k]);
                        ++k;
                    }
                } else if (error == null) {
                    error = curr.getErrorMessage();
                }
                ++i;
            }
            this.fErrorMessage = error;
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavadocContentAssistInvocationContext) {
            JavadocContentAssistInvocationContext javaContext = (JavadocContentAssistInvocationContext)context;
            IJavaScriptUnit cu = javaContext.getCompilationUnit();
            int offset = javaContext.getInvocationOffset();
            int length = javaContext.getSelectionLength();
            Point selection = javaContext.getViewer().getSelectedRange();
            if (selection.y > 0) {
                offset = selection.x;
                length = selection.y;
            }
            ArrayList<IJavaCompletionProposal> result = new ArrayList<IJavaCompletionProposal>();
            IJavadocCompletionProcessor[] processors = this.getContributedProcessors();
            int i = 0;
            while (i < processors.length) {
                IJavadocCompletionProcessor curr = processors[i];
                IJavaCompletionProposal[] proposals = curr.computeCompletionProposals(cu, offset, length, javaContext.getFlags());
                if (proposals != null) {
                    int k = 0;
                    while (k < proposals.length) {
                        result.add(proposals[k]);
                        ++k;
                    }
                }
                ++i;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        this.fErrorMessage = null;
    }
}

