/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.actions;

import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.ui.util.LayoutTemplatesFactory;
import com.liferay.ide.ui.util.UIUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.swt.widgets.Shell;

public class AddLayoutTemplateActionHandlerFactory
extends SapphireActionHandlerFactory {
    private static final String ADD_LAYOUT_TEMPLATE_ACTION_ID = "LayoutTpl.Add.LayoutTemplate";
    private static final String ADD_LAYOUT_1_2_I_ACTION_HANDLER_ID = "Add.Layout.1_2_I.ActionHandler";
    private static final String ADD_LAYOUT_1_2_II_ACTION_HANDLER_ID = "Add.Layout.1_2_II.ActionHandler";
    private static final String ADD_LAYOUT_2_2_ACTION_HANDLER_ID = "Add.Layout.2_2.ActionHandler";
    private static final String ADD_LAYOUT_1_2_1_ACTION_HANDLER_ID = "Add.Layout.1_2_1.ActionHandler";
    private boolean isBootstrapStyle;

    public void init(SapphireAction action, ActionHandlerFactoryDef def) {
        super.init(action, def);
        this.isBootstrapStyle = (Boolean)((LayoutTplElement)this.getModelElement().nearest(LayoutTplElement.class)).getBootstrapStyle().content();
    }

    public List<SapphireActionHandler> create() {
        if (ADD_LAYOUT_TEMPLATE_ACTION_ID.equals(this.getAction().getId())) {
            ArrayList<SapphireActionHandler> actionHandlers = new ArrayList<SapphireActionHandler>();
            actionHandlers.add(new Add_Layout_1_2_I_ActionHandler());
            actionHandlers.add(new Add_Layout_1_2_II_ActionHandler());
            actionHandlers.add(new Add_Layout_2_2_ActionHandler());
            actionHandlers.add(new Add_Layout_1_2_1_ActionHandler());
            return actionHandlers;
        }
        return null;
    }

    private boolean canOverride() {
        return MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)"Warning", (String)Msgs.addLayoutTplWarningMsg);
    }

    private class Add_Layout_1_2_1_ActionHandler
    extends SapphireActionHandler {
        private Add_Layout_1_2_1_ActionHandler() {
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(AddLayoutTemplateActionHandlerFactory.ADD_LAYOUT_1_2_1_ACTION_HANDLER_ID);
            this.setLabel();
        }

        protected void setLabel() {
            if (AddLayoutTemplateActionHandlerFactory.this.isBootstrapStyle) {
                super.setLabel("Layout with 3 Rows (12, (6, 6), 12))");
            } else {
                super.setLabel("Layout with 3 Rows (100, (50, 50), 100)");
            }
        }

        protected Object run(Presentation context) {
            LayoutTplElement element = (LayoutTplElement)context.part().getModelElement().nearest(LayoutTplElement.class);
            if (element.getPortletLayouts().size() == 0 || AddLayoutTemplateActionHandlerFactory.this.canOverride()) {
                element.getPortletLayouts().clear();
                LayoutTemplatesFactory.add_Layout_1_2_1(element);
            }
            return null;
        }
    }

    private class Add_Layout_1_2_II_ActionHandler
    extends SapphireActionHandler {
        private Add_Layout_1_2_II_ActionHandler() {
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(AddLayoutTemplateActionHandlerFactory.ADD_LAYOUT_1_2_II_ACTION_HANDLER_ID);
            this.setLabel();
        }

        protected void setLabel() {
            if (AddLayoutTemplateActionHandlerFactory.this.isBootstrapStyle) {
                super.setLabel("Layout with 2 Rows (12, (8, 4))");
            } else {
                super.setLabel("Layout with 2 Rows (100, (70, 30))");
            }
        }

        protected Object run(Presentation context) {
            LayoutTplElement element = (LayoutTplElement)context.part().getModelElement().nearest(LayoutTplElement.class);
            if (element.getPortletLayouts().size() == 0 || AddLayoutTemplateActionHandlerFactory.this.canOverride()) {
                element.getPortletLayouts().clear();
                LayoutTemplatesFactory.add_Layout_1_2_II(element);
            }
            return null;
        }
    }

    private class Add_Layout_1_2_I_ActionHandler
    extends SapphireActionHandler {
        private Add_Layout_1_2_I_ActionHandler() {
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(AddLayoutTemplateActionHandlerFactory.ADD_LAYOUT_1_2_I_ACTION_HANDLER_ID);
            this.setLabel();
        }

        protected void setLabel() {
            if (AddLayoutTemplateActionHandlerFactory.this.isBootstrapStyle) {
                super.setLabel("Layout with 2 Rows (12, (4, 8))");
            } else {
                super.setLabel("Layout with 2 Rows (100, (30, 70))");
            }
        }

        protected Object run(Presentation context) {
            LayoutTplElement element = (LayoutTplElement)context.part().getModelElement().nearest(LayoutTplElement.class);
            if (element.getPortletLayouts().size() == 0 || AddLayoutTemplateActionHandlerFactory.this.canOverride()) {
                element.getPortletLayouts().clear();
                LayoutTemplatesFactory.add_Layout_1_2_I(element);
            }
            return null;
        }
    }

    private class Add_Layout_2_2_ActionHandler
    extends SapphireActionHandler {
        private Add_Layout_2_2_ActionHandler() {
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(AddLayoutTemplateActionHandlerFactory.ADD_LAYOUT_2_2_ACTION_HANDLER_ID);
            this.setLabel();
        }

        protected void setLabel() {
            if (AddLayoutTemplateActionHandlerFactory.this.isBootstrapStyle) {
                super.setLabel("Layout with 2 Rows ((8, 4), (4, 8))");
            } else {
                super.setLabel("Layout with 2 Rows ((70, 30), (30, 70))");
            }
        }

        protected Object run(Presentation context) {
            LayoutTplElement element = (LayoutTplElement)context.part().getModelElement().nearest(LayoutTplElement.class);
            if (element.getPortletLayouts().size() == 0 || AddLayoutTemplateActionHandlerFactory.this.canOverride()) {
                element.getPortletLayouts().clear();
                LayoutTemplatesFactory.add_Layout_2_2(element);
            }
            return null;
        }
    }

    private static class Msgs
    extends NLS {
        public static String addLayoutTplWarningMsg;

        static {
            Msgs.initializeMessages((String)AddLayoutTemplateActionHandlerFactory.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

