/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.snippets;

import com.liferay.ide.core.util.CoreUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.VariableInsertionDialog;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public class TaglibVariableInsertionDialog
extends VariableInsertionDialog {
    protected IEditorPart editor;

    public TaglibVariableInsertionDialog(Shell parentShell, IEditorPart editor, boolean clearModality) {
        super(parentShell, clearModality);
        this.editor = editor;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            this.replaceUIText(composite, Msgs.variableLowercase, Msgs.attributeLowercase);
            this.replaceUIText(composite, Msgs.variableUppercase, Msgs.attributeUppercase);
        }
        this.fTableViewer.getTable().getColumns()[0].setText(Msgs.attributeName);
        this.fTableViewer.getTable().redraw();
        return control;
    }

    protected void prepareText() {
        String text = this.prepareJSPText();
        if (TaglibVariableInsertionDialog.isFreemarkerEditor(this.editor)) {
            Pattern p1 = Pattern.compile("(.*)-([a-z])(.*)");
            Matcher m1 = p1.matcher(text);
            while (m1.matches()) {
                text = m1.replaceFirst(String.valueOf(m1.group(1)) + m1.group(2).toUpperCase() + m1.group(3));
                m1 = p1.matcher(text);
            }
            text = text.replaceAll("<([a-zA-Z]+):", "<@$1\\.");
            text = text.replaceAll("</([a-zA-Z]+):", "</@$1\\.");
            this.setPreparedText(text);
            return;
        }
        this.setPreparedText(text);
    }

    private String prepareJSPText() {
        String text = this.fItem.getContentString();
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            String value = (String)this.fTableViewer.getColumnData()[1].get(((SnippetVariable)variables[i]).getId());
            if (!CoreUtil.isNullOrEmpty((String)value)) {
                value = " " + variables[i].getName() + "=\"" + value + "\"";
            }
            text = StringUtils.replace((String)text, (String)("${" + variables[i].getName() + "}"), (String)value);
            ++i;
        }
        text = StringUtils.replace((String)text, (String)"${cursor}", (String)"");
        String systemEOL = System.getProperty("line.separator");
        text = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        text = StringUtils.replace((String)text, (String)"\r", (String)"\n");
        if (!"\n".equals(systemEOL) && systemEOL != null) {
            text = StringUtils.replace((String)text, (String)"\n", (String)systemEOL);
        }
        return text;
    }

    private static boolean isFreemarkerEditor(IEditorPart editorPart) {
        try {
            if (((IStorageEditorInput)editorPart.getEditorInput()).getStorage().getName().endsWith(".ftl")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void replaceUIText(Composite parent, String search, String replace) {
        if (parent == null) {
            return;
        }
        if (parent.getChildren() == null || parent.getChildren().length == 0) {
            return;
        }
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Label) {
                Label label = (Label)child;
                if (label.getText() != null) {
                    label.setText(label.getText().replaceAll(search, replace));
                }
            } else if (child instanceof Text) {
                Text text = (Text)child;
                if (text.getText() != null) {
                    text.setText(text.getText().replaceAll(search, replace));
                }
            } else if (child instanceof Composite) {
                this.replaceUIText((Composite)child, search, replace);
            }
            ++n2;
        }
    }

    private static class Msgs
    extends NLS {
        public static String attributeLowercase;
        public static String attributeName;
        public static String attributeUppercase;
        public static String variableLowercase;
        public static String variableUppercase;

        static {
            Msgs.initializeMessages((String)TaglibVariableInsertionDialog.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

