/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors.options;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import tern.server.protocol.JsonHelper;

public class LintRule {
    private final String label;
    private final JsonObject option;

    public LintRule(JsonObject defaultRule, JsonObject options) {
        String ruleId = (String)defaultRule.names().get(0);
        JsonObject labelAndSeverity = (JsonObject)defaultRule.get(ruleId);
        JsonObject option = this.getRuleOption(ruleId, JsonHelper.getString((JsonValue)labelAndSeverity.get("severity")), options);
        this.label = JsonHelper.getString((JsonValue)labelAndSeverity.get("label"));
        this.option = option;
    }

    public String getLabel() {
        return this.label;
    }

    private JsonObject getRuleOption(String ruleId, String defaultSeverity, JsonObject options) {
        JsonObject option = (JsonObject)options.get(ruleId);
        if (option == null) {
            option = new JsonObject();
            option.set("severity", defaultSeverity);
            options.set(ruleId, (JsonValue)option);
        }
        return option;
    }

    public String getSeverity() {
        return JsonHelper.getString((JsonValue)this.option.get("severity"));
    }

    public void setSeverity(String severity) {
        this.option.set("severity", severity);
    }
}

