/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.views;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.views.TernOutlineContentProvider;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.jface.images.TernImagesRegistry;
import tern.server.protocol.outline.JSNode;
import tern.utils.StringUtils;

public class TernOutlineLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public String getText(Object element) {
        if (element == TernOutlineContentProvider.COMPUTING_NODE) {
            return TernUIMessages.TernOutline_computing;
        }
        if (element instanceof JSNode) {
            return ((JSNode)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element == TernOutlineContentProvider.COMPUTING_NODE) {
            return ImageResource.getImage("logo");
        }
        if (element instanceof JSNode) {
            JSNode jsNode = (JSNode)element;
            String jsType = jsNode.getType();
            if (jsNode.isClass()) {
                return TernImagesRegistry.getImage((String)"tern.eclipse.jface.IMG_CLASS");
            }
            boolean isFunction = jsNode.isFunction();
            boolean isArray = jsNode.isArray();
            return TernImagesRegistry.getImage((String)jsType, (boolean)isFunction, (boolean)isArray, (boolean)false);
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        if (element == TernOutlineContentProvider.COMPUTING_NODE) {
            return new StyledString(TernUIMessages.TernOutline_computing);
        }
        if (element instanceof JSNode) {
            JSNode node = (JSNode)element;
            StyledString buff = new StyledString(StringUtils.isEmpty((String)node.getName()) ? "" : node.getName());
            String type = node.getType();
            if (!StringUtils.isEmpty((String)type)) {
                buff.append(" : ", StyledString.DECORATIONS_STYLER);
                buff.append(type, StyledString.DECORATIONS_STYLER);
            }
            return buff;
        }
        return new StyledString(this.getText(element));
    }
}

