/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.sampling;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.sampling.ISampler;
import org.eclipse.recommenders.jayes.util.BayesNodeUtil;

public class BasicSampler
implements ISampler {
    private List<BayesNode> topologicallySortedNodes;
    private Map<BayesNode, String> evidence = Collections.emptyMap();
    private final Random random = new Random();

    @Override
    public Map<BayesNode, String> sample() {
        HashMap<BayesNode, String> result = new HashMap<BayesNode, String>();
        result.putAll(this.evidence);
        for (BayesNode n : this.topologicallySortedNodes) {
            if (this.evidence.containsKey(n)) continue;
            int newEvidence = this.sampleOutcome(n, result);
            result.put(n, n.getOutcomeName(newEvidence));
        }
        return result;
    }

    private int sampleOutcome(BayesNode node, Map<BayesNode, String> currentSample) {
        double[] probs = BayesNodeUtil.getSubCpt(node, currentSample);
        double currentProb = 0.0;
        int newEvidence = 0;
        double rand = this.random.nextDouble();
        double[] dArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            double prob = dArray[n2];
            if (rand < (currentProb += prob)) break;
            ++newEvidence;
            ++n2;
        }
        return Math.min(newEvidence, node.getOutcomeCount() - 1);
    }

    @Override
    public void setNetwork(BayesNet net) {
        this.topologicallySortedNodes = this.topsort(net.getNodes());
    }

    private List<BayesNode> topsort(List<BayesNode> list) {
        LinkedList<BayesNode> result = new LinkedList<BayesNode>();
        HashSet<BayesNode> visited = new HashSet<BayesNode>();
        for (BayesNode n : list) {
            this.depthFirstSearch(n, visited, result);
        }
        Collections.reverse(result);
        return result;
    }

    private void depthFirstSearch(BayesNode n, Set<BayesNode> visited, List<BayesNode> finished) {
        if (visited.contains(n)) {
            return;
        }
        visited.add(n);
        for (BayesNode c : n.getChildren()) {
            this.depthFirstSearch(c, visited, finished);
        }
        finished.add(n);
    }

    @Override
    public void setEvidence(Map<BayesNode, String> evidence) {
        this.evidence = evidence;
    }

    @Override
    public void seed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    @Deprecated
    public void setBN(BayesNet net) {
        this.setNetwork(net);
    }
}

