/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentsInfo
extends ProductObject
implements IArgumentsInfo {
    private static final long serialVersionUID = 1L;
    private String[] fProgramArgs = new String[8];
    private String[] fProgramArgsLin = new String[8];
    private String[] fProgramArgsMac = new String[8];
    private String[] fProgramArgsSol = new String[8];
    private String[] fProgramArgsWin = new String[8];
    private String[] fVMArgs = new String[8];
    private String[] fVMArgsLin = new String[8];
    private String[] fVMArgsMac = new String[8];
    private String[] fVMArgsSol = new String[8];
    private String[] fVMArgsWin = new String[8];

    public ArgumentsInfo(IProductModel model) {
        super(model);
        this.initializeArgs(this.fProgramArgs);
        this.initializeArgs(this.fProgramArgsLin);
        this.initializeArgs(this.fProgramArgsMac);
        this.initializeArgs(this.fProgramArgsSol);
        this.initializeArgs(this.fProgramArgsWin);
        this.initializeArgs(this.fVMArgs);
        this.initializeArgs(this.fVMArgsLin);
        this.initializeArgs(this.fVMArgsMac);
        this.initializeArgs(this.fVMArgsSol);
        this.initializeArgs(this.fVMArgsWin);
    }

    private void initializeArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            args[i] = "";
            ++i;
        }
    }

    @Override
    public void setProgramArguments(String args, int platform) {
        this.setProgramArguments(args, platform, 0);
    }

    @Override
    public void setProgramArguments(String args, int platform, int arch) {
        if (args == null) {
            args = "";
        }
        switch (platform) {
            case 0: {
                String old = this.fProgramArgs[arch];
                this.fProgramArgs[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("programArgs", old, this.fProgramArgs[arch]);
                break;
            }
            case 1: {
                String old = this.fProgramArgsLin[arch];
                this.fProgramArgsLin[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("programArgsLin", old, this.fProgramArgsLin[arch]);
                break;
            }
            case 2: {
                String old = this.fProgramArgsMac[arch];
                this.fProgramArgsMac[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("programArgsMac", old, this.fProgramArgsMac[arch]);
                break;
            }
            case 3: {
                String old = this.fProgramArgsSol[arch];
                this.fProgramArgsSol[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("programArgsSol", old, this.fProgramArgsSol[arch]);
                break;
            }
            case 4: {
                String old = this.fProgramArgsWin[arch];
                this.fProgramArgsWin[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("programArgsWin", old, this.fProgramArgsWin[arch]);
            }
        }
    }

    @Override
    public String getProgramArguments(int platform) {
        return this.getProgramArguments(platform, 0);
    }

    @Override
    public String getProgramArguments(int platform, int arch) {
        switch (platform) {
            case 0: {
                return this.fProgramArgs[arch];
            }
            case 1: {
                return this.fProgramArgsLin[arch];
            }
            case 2: {
                return this.fProgramArgsMac[arch];
            }
            case 3: {
                return this.fProgramArgsSol[arch];
            }
            case 4: {
                return this.fProgramArgsWin[arch];
            }
        }
        return "";
    }

    @Override
    public String getCompleteProgramArguments(String os) {
        return this.getCompleteProgramArguments(os, "");
    }

    @Override
    public String getCompleteProgramArguments(String os, String arch) {
        String archArgsAllPlatforms;
        int archIndex = 0;
        if (arch != null && arch.length() > 0) {
            if ("x86".equals(arch)) {
                archIndex = 1;
            } else if ("x86_64".equals(arch)) {
                archIndex = 2;
            } else if ("ppc".equals(arch)) {
                archIndex = 3;
            } else if ("ia64".equals(arch)) {
                archIndex = 4;
            } else if ("ia64_32".equals(arch)) {
                archIndex = 5;
            } else if ("PA_RISC".equals(arch)) {
                archIndex = 6;
            } else if ("sparc".equals(arch)) {
                archIndex = 7;
            }
        }
        String string = archArgsAllPlatforms = archIndex > 0 ? this.getProgramArguments(0, archIndex) : "";
        if ("win32".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getProgramArguments(4, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getProgramArguments(4), this.fProgramArgs[0]);
        }
        if ("linux".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getProgramArguments(1, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getProgramArguments(1), this.fProgramArgs[0]);
        }
        if ("macosx".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getProgramArguments(2, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getProgramArguments(2), this.fProgramArgs[0]);
        }
        if ("solaris".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getProgramArguments(3, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getProgramArguments(3), this.fProgramArgs[0]);
        }
        return this.getCompleteArgs(archArgsAllPlatforms, "", this.fProgramArgs[0]);
    }

    @Override
    public void setVMArguments(String args, int platform) {
        this.setVMArguments(args, platform, 0);
    }

    @Override
    public void setVMArguments(String args, int platform, int arch) {
        if (args == null) {
            args = "";
        }
        switch (platform) {
            case 0: {
                String old = this.fVMArgs[arch];
                this.fVMArgs[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("vmArgs", old, this.fVMArgs[arch]);
                break;
            }
            case 1: {
                String old = this.fVMArgsLin[arch];
                this.fVMArgsLin[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("vmArgsLin", old, this.fVMArgsLin[arch]);
                break;
            }
            case 2: {
                String old = this.fVMArgsMac[arch];
                this.fVMArgsMac[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("vmArgsMac", old, this.fVMArgsMac[arch]);
                break;
            }
            case 3: {
                String old = this.fVMArgsSol[arch];
                this.fVMArgsSol[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("vmArgsSol", old, this.fVMArgsSol[arch]);
                break;
            }
            case 4: {
                String old = this.fVMArgsWin[arch];
                this.fVMArgsWin[arch] = args;
                if (!this.isEditable()) break;
                this.firePropertyChanged("vmArgsWin", old, this.fVMArgsWin[arch]);
            }
        }
    }

    @Override
    public String getVMArguments(int platform) {
        return this.getVMArguments(platform, 0);
    }

    @Override
    public String getVMArguments(int platform, int arch) {
        switch (platform) {
            case 0: {
                return this.fVMArgs[arch];
            }
            case 1: {
                return this.fVMArgsLin[arch];
            }
            case 2: {
                return this.fVMArgsMac[arch];
            }
            case 3: {
                return this.fVMArgsSol[arch];
            }
            case 4: {
                return this.fVMArgsWin[arch];
            }
        }
        return "";
    }

    @Override
    public String getCompleteVMArguments(String os) {
        return this.getCompleteVMArguments(os, "");
    }

    @Override
    public String getCompleteVMArguments(String os, String arch) {
        String archArgsAllPlatforms;
        int archIndex = 0;
        if (arch != null && arch.length() > 0) {
            if ("x86".equals(arch)) {
                archIndex = 1;
            } else if ("x86_64".equals(arch)) {
                archIndex = 2;
            } else if ("ppc".equals(arch)) {
                archIndex = 3;
            } else if ("ia64".equals(arch)) {
                archIndex = 4;
            } else if ("ia64_32".equals(arch)) {
                archIndex = 5;
            } else if ("PA_RISC".equals(arch)) {
                archIndex = 6;
            } else if ("sparc".equals(arch)) {
                archIndex = 7;
            }
        }
        String string = archArgsAllPlatforms = archIndex > 0 ? this.getVMArguments(0, archIndex) : "";
        if ("win32".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getVMArguments(4, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getVMArguments(4), this.fVMArgs[0]);
        }
        if ("linux".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getVMArguments(1, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getVMArguments(1), this.fVMArgs[0]);
        }
        if ("macosx".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getVMArguments(2, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getVMArguments(2), this.fVMArgs[0]);
        }
        if ("solaris".equals(os)) {
            String archArgs = archIndex > 0 ? String.valueOf(this.getVMArguments(3, archIndex)) + " " + archArgsAllPlatforms : archArgsAllPlatforms;
            return this.getCompleteArgs(archArgs, this.getVMArguments(3), this.fVMArgs[0]);
        }
        return this.getCompleteArgs(archArgsAllPlatforms, "", this.fVMArgs[0]);
    }

    private String getCompleteArgs(String archArgs, String platformArgs, String univArgs) {
        String args = archArgs;
        if (platformArgs.length() > 0) {
            args = String.valueOf(platformArgs) + " " + args;
        }
        if (univArgs.length() > 0) {
            args = String.valueOf(univArgs) + " " + args;
        }
        return args.trim();
    }

    @Override
    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            String[] parentArgs = this.fProgramArgs;
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("programArgs")) {
                    parentArgs = this.fProgramArgs;
                    this.fProgramArgs[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("programArgsLin")) {
                    parentArgs = this.fProgramArgsLin;
                    this.fProgramArgsLin[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("programArgsMac")) {
                    parentArgs = this.fProgramArgsMac;
                    this.fProgramArgsMac[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("programArgsSol")) {
                    parentArgs = this.fProgramArgsSol;
                    this.fProgramArgsSol[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("programArgsWin")) {
                    parentArgs = this.fProgramArgsWin;
                    this.fProgramArgsWin[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("vmArgs")) {
                    parentArgs = this.fVMArgs;
                    this.fVMArgs[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("vmArgsLin")) {
                    parentArgs = this.fVMArgsLin;
                    this.fVMArgsLin[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("vmArgsMac")) {
                    parentArgs = this.fVMArgsMac;
                    this.fVMArgsMac[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("vmArgsSol")) {
                    parentArgs = this.fVMArgsSol;
                    this.fVMArgsSol[0] = this.getText(child).trim();
                } else if (child.getNodeName().equals("vmArgsWin")) {
                    parentArgs = this.fVMArgsWin;
                    this.fVMArgsWin[0] = this.getText(child).trim();
                }
                NodeList childNodes = child.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node arch = childNodes.item(j);
                    if (arch.getNodeType() == 1) {
                        if (arch.getNodeName().equals("argsX86")) {
                            parentArgs[1] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsX86_64")) {
                            parentArgs[2] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsPPC")) {
                            parentArgs[3] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsIA_64")) {
                            parentArgs[4] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsIA_64_32")) {
                            parentArgs[5] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsPA_RISC")) {
                            parentArgs[6] = this.getText(arch).trim();
                        } else if (arch.getNodeName().equals("argsSPARC")) {
                            parentArgs[7] = this.getText(arch).trim();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<launcherArgs>");
        String subIndent = String.valueOf(indent) + "   ";
        if (this.hasArgs(this.fProgramArgs)) {
            writer.print(String.valueOf(subIndent) + "<" + "programArgs" + ">");
            if (this.fProgramArgs[0].length() > 0) {
                writer.print(this.getWritableString(this.fProgramArgs[0]));
            }
            writer.println();
            this.writeArchArgs(this.fProgramArgs, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "programArgs" + ">");
        }
        if (this.hasArgs(this.fProgramArgsLin)) {
            writer.print(String.valueOf(subIndent) + "<" + "programArgsLin" + ">");
            if (this.fProgramArgsLin[0].length() > 0) {
                writer.print(this.getWritableString(this.fProgramArgsLin[0]));
            }
            writer.println();
            this.writeArchArgs(this.fProgramArgsLin, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "programArgsLin" + ">");
        }
        if (this.hasArgs(this.fProgramArgsMac)) {
            writer.print(String.valueOf(subIndent) + "<" + "programArgsMac" + ">");
            if (this.fProgramArgsMac[0].length() > 0) {
                writer.print(this.getWritableString(this.fProgramArgsMac[0]));
            }
            writer.println();
            this.writeArchArgs(this.fProgramArgsMac, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "programArgsMac" + ">");
        }
        if (this.hasArgs(this.fProgramArgsSol)) {
            writer.print(String.valueOf(subIndent) + "<" + "programArgsSol" + ">");
            if (this.fProgramArgsSol[0].length() > 0) {
                writer.print(this.getWritableString(this.fProgramArgsSol[0]));
            }
            writer.println();
            this.writeArchArgs(this.fProgramArgsSol, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "programArgsSol" + ">");
        }
        if (this.hasArgs(this.fProgramArgsWin)) {
            writer.print(String.valueOf(subIndent) + "<" + "programArgsWin" + ">");
            if (this.fProgramArgsWin[0].length() > 0) {
                writer.print(this.getWritableString(this.fProgramArgsWin[0]));
            }
            writer.println();
            this.writeArchArgs(this.fProgramArgsWin, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "programArgsWin" + ">");
        }
        if (this.hasArgs(this.fVMArgs)) {
            writer.print(String.valueOf(subIndent) + "<" + "vmArgs" + ">");
            if (this.fVMArgs[0].length() > 0) {
                writer.print(this.getWritableString(this.fVMArgs[0]));
            }
            writer.println();
            this.writeArchArgs(this.fVMArgs, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "vmArgs" + ">");
        }
        if (this.hasArgs(this.fVMArgsLin)) {
            writer.print(String.valueOf(subIndent) + "<" + "vmArgsLin" + ">");
            if (this.fVMArgsLin[0].length() > 0) {
                writer.print(this.getWritableString(this.fVMArgsLin[0]));
            }
            writer.println();
            this.writeArchArgs(this.fVMArgsLin, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "vmArgsLin" + ">");
        }
        if (this.hasArgs(this.fVMArgsMac)) {
            writer.print(String.valueOf(subIndent) + "<" + "vmArgsMac" + ">");
            if (this.fVMArgsMac[0].length() > 0) {
                writer.print(this.getWritableString(this.fVMArgsMac[0]));
            }
            writer.println();
            this.writeArchArgs(this.fVMArgsMac, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "vmArgsMac" + ">");
        }
        if (this.hasArgs(this.fVMArgsSol)) {
            writer.print(String.valueOf(subIndent) + "<" + "vmArgsSol" + ">");
            if (this.fVMArgsSol[0].length() > 0) {
                writer.print(this.getWritableString(this.fVMArgsSol[0]));
            }
            writer.println();
            this.writeArchArgs(this.fVMArgsSol, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "vmArgsSol" + ">");
        }
        if (this.hasArgs(this.fVMArgsWin)) {
            writer.print(String.valueOf(subIndent) + "<" + "vmArgsWin" + ">");
            if (this.fVMArgsWin[0].length() > 0) {
                writer.print(this.getWritableString(this.fVMArgsWin[0]));
            }
            writer.println();
            this.writeArchArgs(this.fVMArgsWin, subIndent, writer);
            writer.println(String.valueOf(subIndent) + "</" + "vmArgsWin" + ">");
        }
        writer.println(String.valueOf(indent) + "</launcherArgs>");
    }

    private boolean hasArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeArchArgs(String[] args, String indent, PrintWriter writer) {
        if (args[1].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsX86" + ">" + this.getWritableString(args[1]) + "</" + "argsX86" + ">");
        }
        if (args[2].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsX86_64" + ">" + this.getWritableString(args[2]) + "</" + "argsX86_64" + ">");
        }
        if (args[3].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsPPC" + ">" + this.getWritableString(args[3]) + "</" + "argsPPC" + ">");
        }
        if (args[4].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsIA_64" + ">" + this.getWritableString(args[4]) + "</" + "argsIA_64" + ">");
        }
        if (args[5].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsIA_64_32" + ">" + this.getWritableString(args[5]) + "</" + "argsIA_64_32" + ">");
        }
        if (args[6].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsPA_RISC" + ">" + this.getWritableString(args[6]) + "</" + "argsPA_RISC" + ">");
        }
        if (args[7].length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "argsSPARC" + ">" + this.getWritableString(args[7]) + "</" + "argsSPARC" + ">");
        }
    }
}

