/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.lfportlet.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class NumberValueValidationService
extends ValidationService {
    private String min;
    private String max;
    private Integer value;

    protected void initValidationService() {
        super.initValidationService();
        this.min = this.param("min");
        this.max = this.param("max");
    }

    protected Status compute() {
        String triggerValue;
        Element modelElement = (Element)this.context(Element.class);
        if (!modelElement.disposed() && !CoreUtil.isNullOrEmpty((String)(triggerValue = (String)modelElement.property((ValueProperty)this.context(ValueProperty.class)).content()))) {
            try {
                this.value = Integer.valueOf(triggerValue);
            }
            catch (NumberFormatException numberFormatException) {
                return Status.createErrorStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.nonIntegerInvalid), (Object[])new Object[]{triggerValue, ""}));
            }
            if (!CoreUtil.isNullOrEmpty((String)this.min) && this.value < Integer.valueOf(this.min)) {
                return Status.createErrorStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.minNumberValueInvalid), (Object[])new Object[]{this.value, this.min}));
            }
            if (!CoreUtil.isNullOrEmpty((String)this.max) && this.value > Integer.valueOf(this.max)) {
                return Status.createErrorStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.maxNumberValueInvalid), (Object[])new Object[]{this.value, this.max}));
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String minNumberValueInvalid;
        public static String maxNumberValueInvalid;
        public static String nonIntegerInvalid;

        static {
            Resources.initializeMessages((String)NumberValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

