/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.adapter.NoopLiferayProject;
import com.liferay.ide.core.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Version;
import org.w3c.dom.Node;

public class CoreUtil {
    public static void addNaturesToProject(IProject proj, String[] natureIds, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + natureIds.length];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        int i = prevNatures.length;
        while (i < newNatures.length) {
            newNatures[i] = natureIds[i - prevNatures.length];
            ++i;
        }
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static int compareVersions(Version v1, Version v2) {
        if (v2 == v1) {
            return 0;
        }
        int result = v1.getMajor() - v2.getMajor();
        if (result != 0) {
            return result;
        }
        result = v1.getMinor() - v2.getMinor();
        if (result != 0) {
            return result;
        }
        result = v1.getMicro() - v2.getMicro();
        if (result != 0) {
            return result;
        }
        return v1.getQualifier().compareTo(v2.getQualifier());
    }

    public static boolean containsNullElement(Object[] array) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return true;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void createEmptyFile(IFile newFile) throws CoreException {
        if (newFile.getParent() instanceof IFolder) {
            CoreUtil.prepareFolder((IFolder)newFile.getParent());
        }
        newFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.core", msg);
    }

    public static final String createStringDigest(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] input = str.getBytes("UTF-8");
            byte[] digest = md.digest(input);
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    buf.append('0');
                }
                buf.append(hex);
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteResource(IResource resource) throws CoreException {
        if (resource == null || !resource.exists()) {
            return;
        }
        resource.delete(true, null);
    }

    public static boolean empty(Object[] array) {
        return CoreUtil.isNullOrEmpty(array);
    }

    public static boolean empty(String val) {
        return CoreUtil.isNullOrEmpty(val);
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static IClasspathEntry[] getClasspathEntries(IProject project) {
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
                return classPathEntries;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static IFolder getDefaultDocrootFolder(IProject project) {
        IFolder retval = null;
        IWebProject webproject = LiferayCore.create(IWebProject.class, project);
        if (webproject != null) {
            retval = webproject.getDefaultDocrootFolder();
        }
        return retval;
    }

    public static IProject getLiferayProject(IResource resource) {
        IProject project = null;
        if (resource != null && resource.exists()) {
            project = resource.getProject();
        }
        if (project != null && project.exists()) {
            IProject[] projects;
            if (CoreUtil.isLiferayProject(project)) {
                return project;
            }
            IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (proj.getLocation() != null && project.getLocation().isPrefixOf(proj.getLocation()) && CoreUtil.isLiferayProject(proj)) {
                    return proj;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IProject getLiferayProject(String projectName) {
        return CoreUtil.getLiferayProject((IResource)CoreUtil.getProject(projectName));
    }

    public static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    public static IProject getProject(String projectName) {
        return CoreUtil.getWorkspaceRoot().getProject(projectName);
    }

    public static IPath getResourceLocation(IResource resource) {
        IPath retval = null;
        if (resource != null && (retval = resource.getLocation()) == null) {
            retval = resource.getRawLocation();
        }
        return retval;
    }

    public static final List<IFolder> getSourceFolders(IJavaProject project) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        if (project != null) {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = project.readRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 0) {
                    Object container = null;
                    container = entry.getPath().segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath());
                    if (!folders.contains(container) && container instanceof IFolder) {
                        folders.add((IFolder)container);
                    }
                }
                ++n2;
            }
        }
        return folders;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static Object invoke(String methodName, Object object, Class<?>[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod(methodName, argTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static boolean isBundleOnlyProject(IProject project) {
        ILiferayProject liferayProject = LiferayCore.create(project);
        return liferayProject instanceof IBundleProject && !(liferayProject instanceof IWebProject);
    }

    public static boolean isEqual(Object object1, Object object2) {
        return object1 != null && object2 != null && object1.equals(object2);
    }

    public static boolean isLiferayProject(IProject project) {
        if (project != null) {
            ILiferayProject lrproject = LiferayCore.create(project);
            return lrproject != null && !(lrproject instanceof NoopLiferayProject);
        }
        return false;
    }

    public static boolean isLinux() {
        return "linux".equals(Platform.getOS());
    }

    public static boolean isMac() {
        return "macosx".equals(Platform.getOS());
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(String val) {
        return val == null || val.equals("") || val.trim().equals("");
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isWindows() {
        return "win32".equals(Platform.getOS());
    }

    public static void makeFolders(IFolder folder) throws CoreException {
        if (folder == null) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CoreUtil.makeFolders((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    public static IProgressMonitor newSubMonitor(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public static void prepareFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CoreUtil.prepareFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(1, true, null);
        }
    }

    public static String readPropertyFileValue(File propertiesFile, String key) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            Properties props = new Properties();
            props.load(fis);
            return props.getProperty(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readStreamToString(InputStream contents) throws IOException {
        return CoreUtil.readStreamToString(contents, true);
    }

    public static String readStreamToString(InputStream contents, boolean closeStream) throws IOException {
        int read;
        if (contents == null) {
            return null;
        }
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(contents, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        if (closeStream) {
            contents.close();
        }
        return out.toString();
    }

    public static Version readVersionFile(File versionInfoFile) {
        String versionContents = FileUtil.readContents(versionInfoFile);
        if (CoreUtil.isNullOrEmpty(versionContents)) {
            return Version.emptyVersion;
        }
        Version version = null;
        try {
            version = Version.parseVersion((String)versionContents.trim());
        }
        catch (NumberFormatException numberFormatException) {
            version = Version.emptyVersion;
        }
        return version;
    }

    public static void removeChildren(Node node) {
        if (node != null) {
            while (node.hasChildNodes()) {
                node.removeChild(node.getFirstChild());
            }
        }
    }

    public static void writeStreamFromString(String contents, OutputStream outputStream) throws IOException {
        int read;
        if (contents == null) {
            return;
        }
        char[] buffer = new char[65536];
        InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(contents.getBytes("UTF-8")));
        OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            ((Writer)out).write(buffer, 0, read);
        } while (read >= 0);
        ((Reader)in).close();
        ((Writer)out).flush();
        ((Writer)out).close();
    }
}

