/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.VariableClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;

public class RuntimeClasspathModel {
    public static final int USER = 1;
    private List<Object> userEntries = new ArrayList<Object>();
    private ILaunchConfigurationWorkingCopy config;

    public RuntimeClasspathModel(ILaunchConfigurationWorkingCopy config) {
        this.config = config;
    }

    public void addEntry(int type, IRuntimeClasspathEntry entry) {
        if (type == 1) {
            this.userEntries.add(entry);
        }
    }

    public IClasspathEntry[] getEntries(int type, ILaunchConfiguration config) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        if (type == 1) {
            for (Object entry : this.userEntries) {
                IClasspathEntry newEntry;
                if (entry instanceof VariableClasspathEntry) {
                    VariableClasspathEntry runtimeClasspathEntry = (VariableClasspathEntry)entry;
                    newEntry = JavaCore.newLibraryEntry((IPath)new Path(runtimeClasspathEntry.getVariableString()), null, null);
                    entries.add(newEntry);
                    continue;
                }
                if (entry instanceof IRuntimeClasspathEntry2) {
                    IRuntimeClasspathEntry2 entry2 = (IRuntimeClasspathEntry2)entry;
                    try {
                        IRuntimeClasspathEntry[] runtimeEntries;
                        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = runtimeEntries = entry2.getRuntimeClasspathEntries(config);
                        int n = runtimeEntries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRuntimeClasspathEntry e = iRuntimeClasspathEntryArray[n2];
                            IClasspathEntry newEntry2 = null;
                            if (e.getType() == 3) {
                                newEntry2 = JavaCore.newLibraryEntry((IPath)e.getPath(), null, null);
                            } else if (e.getType() == 2) {
                                newEntry2 = JavaCore.newLibraryEntry((IPath)e.getPath(), null, null);
                            } else if (e instanceof VariableClasspathEntry) {
                                VariableClasspathEntry vce = (VariableClasspathEntry)e;
                                newEntry2 = JavaCore.newLibraryEntry((IPath)new Path(vce.getVariableString()), null, null);
                            }
                            if (newEntry2 != null) {
                                entries.add(newEntry2);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        LiferayCore.logError("error creating runtime classpath entry", e);
                    }
                    continue;
                }
                if (entry instanceof IRuntimeClasspathEntry) {
                    IRuntimeClasspathEntry rEntry = (IRuntimeClasspathEntry)entry;
                    newEntry = null;
                    if (rEntry.getType() == 3) {
                        newEntry = JavaCore.newVariableEntry((IPath)rEntry.getPath(), null, null);
                    } else if (rEntry.getType() == 2) {
                        newEntry = JavaCore.newLibraryEntry((IPath)rEntry.getPath(), null, null);
                    } else {
                        System.out.println(rEntry.getType());
                    }
                    if (newEntry == null) continue;
                    entries.add(newEntry);
                    continue;
                }
                System.out.println(entry);
            }
        }
        return entries.toArray(new IClasspathEntry[0]);
    }

    public ILaunchConfiguration getConfig() {
        return this.config;
    }
}

