/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui;

import com.liferay.ide.hook.core.util.HookUtil;
import com.liferay.ide.hook.ui.HookUI;
import com.liferay.ide.ui.util.UIUtil;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;

public class HookCustomJspValidationResolution
implements IMarkerResolution2 {
    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        URL url = HookUI.getDefault().getBundle().getEntry("/icons/e16/disabled.png");
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    public String getLabel() {
        return Msgs.disableCustomJspValidation;
    }

    public void run(IMarker marker) {
        boolean retval;
        final IProject project = marker.getResource().getProject();
        IPath customJspPath = HookUtil.getCustomJspPath((IProject)project);
        if (customJspPath != null && (retval = HookUtil.configureJSPSyntaxValidationExclude((IProject)project, (IFolder)project.getFolder(customJspPath.makeRelativeTo(project.getFullPath())), (boolean)true))) {
            UIUtil.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean revalidate = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)Msgs.revalidateTitle, (String)Msgs.revalidateMsg);
                    if (revalidate) {
                        new WorkspaceJob("revalidating " + project.getName()){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                project.build(6, (IProgressMonitor)new NullProgressMonitor());
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
            });
        }
    }

    private static class Msgs
    extends NLS {
        public static String disableCustomJspValidation;
        public static String revalidateMsg;
        public static String revalidateTitle;

        static {
            Msgs.initializeMessages((String)HookCustomJspValidationResolution.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

