/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.action;

import com.liferay.ide.hook.core.model.ServiceWrapper;
import com.liferay.ide.hook.ui.HookUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class ServiceTypeImplBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "ServiceTypeImpl.Browse.Java.Type";
    private int browseDialogStyle;
    private String kind;

    public String browse(Presentation context) {
        TypeSelectionExtension extension;
        IJavaSearchScope scope;
        Value property;
        block8: {
            Element element = this.getModelElement();
            property = this.property();
            IProject project = (IProject)element.adapt(IProject.class);
            scope = null;
            extension = null;
            if ("type".equals(this.kind)) {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{JavaCore.create((IProject)project)});
                extension = new TypeSelectionExtension(){

                    public ITypeInfoFilterExtension getFilterExtension() {
                        return new ITypeInfoFilterExtension(){

                            public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                                return typeInfoRequestor.getPackageName().startsWith("com.liferay") && typeInfoRequestor.getTypeName().endsWith("Service");
                            }
                        };
                    }
                };
                break block8;
            }
            if (!"impl".equals(this.kind)) break block8;
            String serviceType = this.getServiceType(element, (Property)property);
            if (serviceType != null) {
                String wrapperType = String.valueOf(serviceType) + "Wrapper";
                scope = SearchEngine.createHierarchyScope((IType)JavaCore.create((IProject)project).findType(wrapperType));
                break block8;
            }
            MessageDialog.openInformation((Shell)((SwtPresentation)context).shell(), (String)Msgs.serviceImplBrowse, (String)Msgs.validServiceTypeProperty);
            return null;
        }
        try {
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)((SwtPresentation)context).shell(), null, (IJavaSearchScope)scope, (int)this.browseDialogStyle, (boolean)false, (String)"**", (TypeSelectionExtension)extension);
            String title = property.definition().getLabel(true, CapitalizationType.TITLE_STYLE, false);
            dlg.setTitle(String.valueOf(Msgs.select) + title);
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IType) {
                    return ((IType)results[0]).getFullyQualifiedName();
                }
            }
        }
        catch (JavaModelException e) {
            HookUI.logError((Exception)((Object)e));
        }
        return null;
    }

    private String getServiceType(Element element, Property property) {
        String retval = null;
        ServiceWrapper service = (ServiceWrapper)element.nearest(ServiceWrapper.class);
        JavaTypeName javaTypeName = (JavaTypeName)service.getServiceType().content(false);
        if (javaTypeName != null) {
            retval = javaTypeName.qualified();
        }
        return retval;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.kind = def.getParam("kind");
        if ("type".equals(this.kind)) {
            this.browseDialogStyle = 4;
        } else if ("impl".equals(this.kind)) {
            this.browseDialogStyle = 2;
        }
    }

    private static class Msgs
    extends NLS {
        public static String select;
        public static String serviceImplBrowse;
        public static String validServiceTypeProperty;

        static {
            Msgs.initializeMessages((String)ServiceTypeImplBrowseActionHandler.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

