/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.news;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.recommenders.internal.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Pair;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RssParser {
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.UK);
    protected static final String FILTER_TAG = "ide-news";

    public static List<Pair<String, URL>> getEntries(String xml, Date fromDate) {
        if (Strings.isNullOrEmpty((String)xml)) {
            return Collections.emptyList();
        }
        if (fromDate == null) {
            return Collections.emptyList();
        }
        ArrayList entries = Lists.newArrayList();
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList items = (NodeList)xPath.compile("rss/channel/item").evaluate(new InputSource(new StringReader(xml)), XPathConstants.NODESET);
            int i = 0;
            while (i < items.getLength()) {
                Pair item = (Pair)RssParser.getItem(xPath, items.item(i), fromDate).orNull();
                if (item != null) {
                    entries.add(item);
                }
                ++i;
            }
            return entries;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARNING_EXCEPTION_PARSING_NEWS_FEED, (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static Optional<Pair<String, URL>> getItem(XPath xPath, Node item, Date fromDate) {
        try {
            Date date = DATE_FORMAT.parse(xPath.evaluate("pubDate", item));
            if (date.before(fromDate)) {
                return Optional.absent();
            }
            if (!RssParser.hasTag(xPath, item, FILTER_TAG)) {
                return Optional.absent();
            }
            String title = xPath.evaluate("title", item);
            URL url = new URL(xPath.evaluate("link", item));
            return Optional.of((Object)Pair.newPair((Object)title, (Object)url));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARNING_EXCEPTION_PARSING_NEWS_FEED_ITEM, (Throwable)e);
            return Optional.absent();
        }
    }

    private static boolean hasTag(XPath xPath, Node item, String tag) throws XPathExpressionException {
        NodeList tagList = (NodeList)xPath.evaluate("category", item, XPathConstants.NODESET);
        boolean foundTag = false;
        int i = 0;
        while (i < tagList.getLength()) {
            Node tagItem = tagList.item(i);
            if (tag.equals(tagItem.getFirstChild().getNodeValue())) {
                foundTag = true;
                break;
            }
            ++i;
        }
        return foundTag;
    }
}

