/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConfiguration;
import com.liferay.ide.server.tomcat.core.LiferayTomcatServer;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.server.util.LiferayPublishHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.w3c.dom.Document;

public class LiferayTomcatServerBehavior
extends TomcatServerBehaviour
implements ILiferayServerBehavior {
    private List<IModule[]> redeployModules;

    protected MultiStatus executePublishers(int kind, List<IModule[]> modules, List<Integer> deltaKinds, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        return super.executePublishers(kind, this.redeployModules == null ? modules : this.redeployModules, deltaKinds, monitor, info);
    }

    public IPath getDeployedPath(IModule[] module) {
        return this.getModuleDeployDirectory(module[0]);
    }

    public IPath getModuleDeployDirectory(IModule module) {
        IProject project;
        String requiredSuffix;
        IPath defaultPath = super.getModuleDeployDirectory(module);
        IPath updatedPath = null;
        if (defaultPath != null && defaultPath.lastSegment() != null && (requiredSuffix = ProjectUtil.getRequiredSuffix((IProject)(project = module.getProject()))) != null && !defaultPath.lastSegment().endsWith(requiredSuffix)) {
            String lastSegment = defaultPath.lastSegment();
            updatedPath = defaultPath.removeLastSegments(1).append(String.valueOf(lastSegment) + requiredSuffix);
        }
        return updatedPath == null ? defaultPath : updatedPath;
    }

    public LiferayTomcatServer getLiferayTomcatServer() {
        return (LiferayTomcatServer)this.getServer().loadAdapter(LiferayTomcatServer.class, null);
    }

    public IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    public List<IModule[]> getRedeployModules() {
        return this.redeployModules;
    }

    public String[] getRuntimeVMArguments() {
        return super.getRuntimeVMArguments();
    }

    public IStatus moveContextToAutoDeployDir(IModule module, IPath deployDir, IPath baseDir, IPath autoDeployDir, boolean noPath, boolean serverStopped) {
        IPath confDir = baseDir.append("conf");
        IPath serverXml = confDir.append("server.xml");
        try {
            Factory factory = new Factory();
            factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            Server publishedServer = (Server)factory.loadDocument((InputStream)new FileInputStream(serverXml.toFile()));
            ServerInstance publishedInstance = new ServerInstance(publishedServer, null, null);
            IPath contextPath = null;
            contextPath = autoDeployDir.isAbsolute() ? autoDeployDir : baseDir.append(autoDeployDir);
            File contextDir = contextPath.toFile();
            if (!contextDir.exists()) {
                contextDir.mkdirs();
            }
            Context context = publishedInstance.createContext(-1);
            context.setReloadable("true");
            String moduleName = module.getName();
            String requiredSuffix = ProjectUtil.getRequiredSuffix((IProject)module.getProject());
            String contextName = moduleName;
            if (!moduleName.endsWith(requiredSuffix)) {
                contextName = String.valueOf(moduleName) + requiredSuffix;
            }
            context.setSource("org.eclipse.jst.jee.server:" + contextName);
            if (Boolean.valueOf(context.getAttributeValue("antiResourceLocking")).booleanValue()) {
                context.setAttributeValue("antiResourceLocking", "false");
            }
            File contextFile = new File(contextDir, String.valueOf(contextName) + ".xml");
            if (!LiferayTomcatUtil.isExtProjectContext(context)) {
                if (noPath) {
                    context.removeAttribute("path");
                }
                context.setDocBase(deployDir.toOSString());
                DocumentBuilder builder = XMLUtil.getDocumentBuilder();
                Document contextDoc = builder.newDocument();
                contextDoc.appendChild(contextDoc.importNode(context.getElementNode(), true));
                XMLUtil.save((String)contextFile.getAbsolutePath(), (Document)contextDoc);
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public ILiferayTomcatConfiguration getLiferayTomcatConfiguration() throws CoreException {
        return this.getLiferayTomcatServer().getLiferayTomcatConfiguration();
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        super.publishFinish(monitor);
        this.redeployModules = null;
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        boolean shouldPublishModule = LiferayPublishHelper.prePublishModule((ServerBehaviourDelegate)this, (int)kind, (int)deltaKind, (IModule[])moduleTree, (IModuleResourceDelta[])this.getPublishedResourceDelta(moduleTree), (IProgressMonitor)monitor);
        if (shouldPublishModule) {
            if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
                this.setServerRestartState(true);
            }
            this.setModulePublishState(moduleTree, 1);
        } else {
            this.setModulePublishState(moduleTree, 3);
        }
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        super.publishModules(kind, this.redeployModules == null ? modules : this.redeployModules, deltaKind2, multi, monitor);
    }

    public void redeployModule(IModule[] module) throws CoreException {
        this.setModulePublishState(module, 3);
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                return null;
            }
        };
        ArrayList<IModule[]> modules = new ArrayList<IModule[]>();
        modules.add(module);
        this.redeployModules = modules;
        try {
            this.publish(2, modules, null, info);
        }
        finally {
            this.redeployModules = null;
        }
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        super.setupLaunchConfiguration(workingCopy, monitor);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "UTF-8");
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        if (existingVMArgs != null) {
            Object[] parsedVMArgs = DebugPlugin.parseArguments((String)existingVMArgs);
            ArrayList<Object> memoryArgs = new ArrayList<Object>();
            if (!CoreUtil.isNullOrEmpty((Object[])parsedVMArgs)) {
                Object[] objectArray = parsedVMArgs;
                int n = parsedVMArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object pArg = objectArray[n2];
                    if (((String)pArg).startsWith("-Xm") || ((String)pArg).startsWith("-XX:")) {
                        memoryArgs.add(pArg);
                    }
                    ++n2;
                }
            }
            String argsWithoutMem = LiferayTomcatServerBehavior.mergeArguments((String)existingVMArgs, (String[])this.getRuntimeVMArguments(), (String[])memoryArgs.toArray(new String[0]), (boolean)false);
            String fixedArgs = LiferayTomcatServerBehavior.mergeArguments((String)argsWithoutMem, (String[])this.getRuntimeVMArguments(), null, (boolean)false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, fixedArgs);
        }
    }
}

