/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.operation;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.LayoutTplCore;
import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.layouttpl.core.operation.LayoutTplDescriptorHelper;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;

public class NewLayoutTplDataModelProvider
extends ArtifactEditOperationDataModelProvider
implements INewLayoutTplDataModelProperties {
    protected boolean ignoreLayoutOptionPropertySet = false;

    private boolean checkDocrootFileExists(IPath path) {
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.getTargetProject());
        if (webproject != null) {
            IFolder defaultDocroot = webproject.getDefaultDocrootFolder();
            return defaultDocroot != null && defaultDocroot.exists(path);
        }
        return false;
    }

    private boolean checkoutDocrootFileNameCorrect(String filename, String type) {
        int firstindex = filename.indexOf("/");
        int lastindex = filename.lastIndexOf("." + type);
        String filetype = filename.substring(lastindex + 1);
        return lastindex != -1 && !CoreUtil.isNullOrEmpty((String)(filename = firstindex != -1 ? filename.substring(firstindex + 1, lastindex) : filename.substring(0, lastindex))) && !filename.startsWith("/") && !filename.startsWith(".") && !CoreUtil.isNullOrEmpty((String)filetype);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME".equals(propertyName)) {
            return "New Template";
        }
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            String name = this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
            if (!CoreUtil.isNullOrEmpty((String)name)) {
                return name.replaceAll("[^a-zA-Z0-9]+", "").toLowerCase();
            }
        } else {
            if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".wap.tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".png";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN".equals(propertyName)) {
                return true;
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN".equals(propertyName)) {
                return false;
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED");
        return propertyNames;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean isLayoutOption = false;
        int i = 0;
        while (i < LAYOUT_PROPERTIES.length) {
            if (LAYOUT_PROPERTIES[i].equals(propertyName)) {
                isLayoutOption = true;
                break;
            }
            ++i;
        }
        if (isLayoutOption && !this.ignoreLayoutOptionPropertySet) {
            this.ignoreLayoutOptionPropertySet = true;
            i = 0;
            while (i < LAYOUT_PROPERTIES.length) {
                this.setBooleanProperty(LAYOUT_PROPERTIES[i], false);
                ++i;
            }
            this.setProperty(propertyName, propertyValue);
            this.ignoreLayoutOptionPropertySet = false;
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            LayoutTplDescriptorHelper helper = new LayoutTplDescriptorHelper(this.getTargetProject());
            if (helper.hasTemplateId(this.getStringProperty(propertyName))) {
                return LayoutTplCore.createErrorStatus(Msgs.templateIdExists);
            }
            String idValue = String.valueOf(this.getStringProperty(propertyName)) + "z";
            if (CoreUtil.isNullOrEmpty((String)idValue)) {
                return super.validate(propertyName);
            }
            IStatus status = JavaConventions.validateFieldName((String)idValue, (String)"1.5", (String)"1.5");
            if (!status.isOK()) {
                return LayoutTplCore.createErrorStatus(Msgs.templateIdInvalid);
            }
            String idText = this.getStringProperty(propertyName);
            if (CoreUtil.isNullOrEmpty((String)idText)) {
                return LayoutTplCore.createErrorStatus("Id can't be empty.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
            String filename = this.getStringProperty(propertyName);
            if (!this.checkoutDocrootFileNameCorrect(filename, "tpl")) {
                return LayoutTplCore.createErrorStatus("Template file name is invalid.");
            }
            Path filePath = new Path(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE"));
            if (this.checkDocrootFileExists((IPath)filePath)) {
                return LayoutTplCore.createWarningStatus(Msgs.templateFileExists);
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
            String filename = this.getStringProperty(propertyName);
            if (!this.checkoutDocrootFileNameCorrect(filename, "tpl")) {
                return LayoutTplCore.createErrorStatus("WAP template file name is invalid.");
            }
            Path filePath = new Path(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE"));
            if (this.checkDocrootFileExists((IPath)filePath)) {
                return LayoutTplCore.createWarningStatus(Msgs.wapTemplateFileExists);
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName)) {
            String filename = this.getStringProperty(propertyName);
            if (!this.checkoutDocrootFileNameCorrect(filename, "")) {
                return LayoutTplCore.createErrorStatus("Thumbnail file name is invalid.");
            }
            Path filePath = new Path(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE"));
            if (this.checkDocrootFileExists((IPath)filePath)) {
                return LayoutTplCore.createWarningStatus(Msgs.thumbnailFileExists);
            }
        }
        return super.validate(propertyName);
    }

    private static class Msgs
    extends NLS {
        public static String templateFileExists;
        public static String templateIdExists;
        public static String templateIdInvalid;
        public static String thumbnailFileExists;
        public static String wapTemplateFileExists;

        static {
            Msgs.initializeMessages((String)NewLayoutTplDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

