/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatRuntimeComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LiferayTomcatRuntimeOptionalComposite
extends TomcatRuntimeComposite
implements ModifyListener {
    protected boolean ignoreModifyEvent;
    private Text javadocField;
    private Text sourceField;

    public static void setFieldValue(Text field, String value) {
        if (field != null && !field.isDisposed()) {
            field.setText(value != null ? value : "");
        }
    }

    public LiferayTomcatRuntimeOptionalComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
        wizard.setTitle(Msgs.liferayRuntimeTomcatBundle);
        wizard.setDescription(Msgs.specifyExtraSettings);
        wizard.setImageDescriptor(LiferayServerUI.getImageDescriptor((String)"imgWizRuntime"));
    }

    protected Button createButton(String text, int style) {
        Button button = new Button((Composite)this, style);
        button.setText(text);
        GridDataFactory.generate((Control)button, (int)2, (int)1);
        return button;
    }

    protected void createControl() {
        this.setLayout(this.createLayout());
        this.setLayoutData(new GridData(1808));
        this.javadocField = LiferayTomcatRuntimeOptionalComposite.createJavadocField((Composite)this);
        this.javadocField.addModifyListener((ModifyListener)this);
        this.sourceField = LiferayTomcatRuntimeOptionalComposite.createSourceField((Composite)this);
        this.sourceField.addModifyListener((ModifyListener)this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
    }

    public static Text createJavadocField(final Composite parent) {
        final Text javadocField = LiferayTomcatRuntimeOptionalComposite.createTextField(parent, Msgs.liferayJavadocURL);
        SWTUtil.createButton((Composite)parent, (String)Msgs.browseZip).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(parent.getShell());
                fd.setText(Msgs.selectLiferayJavadocZipFile);
                String selectedFile = fd.open();
                if (selectedFile != null) {
                    String javadocZipURL = LiferayTomcatRuntimeOptionalComposite.getJavadocZipURL(selectedFile);
                    if (javadocZipURL != null) {
                        javadocField.setText(javadocZipURL);
                    } else {
                        MessageDialog.openInformation((Shell)parent.getShell(), (String)Msgs.liferayTomcatRuntime, (String)Msgs.fileNotValid);
                    }
                }
            }
        });
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createButton((Composite)parent, (String)Msgs.browseDirectory).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(parent.getShell());
                dd.setText(Msgs.selectLiferayJavadocDirectory);
                dd.setFilterPath(javadocField.getText());
                String selectedFile = dd.open();
                if (selectedFile != null) {
                    String javadocDirectoryURL = LiferayTomcatRuntimeOptionalComposite.getJavadocDirectoryURL(selectedFile);
                    if (javadocDirectoryURL != null) {
                        javadocField.setText(javadocDirectoryURL);
                    } else {
                        MessageDialog.openInformation((Shell)parent.getShell(), (String)Msgs.liferayTomcatRuntime, (String)Msgs.directoryNotValid);
                    }
                }
            }
        });
        return javadocField;
    }

    public static Text createSourceField(final Composite parent) {
        final Text sourceField = LiferayTomcatRuntimeOptionalComposite.createTextField(parent, Msgs.liferaysourceLocation);
        SWTUtil.createButton((Composite)parent, (String)Msgs.browseZip).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(parent.getShell());
                fd.setText(Msgs.selectLiferaySourceZipFile);
                String selectedFile = fd.open();
                if (selectedFile != null && new File(selectedFile).exists()) {
                    sourceField.setText(selectedFile);
                }
            }
        });
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createButton((Composite)parent, (String)Msgs.browseDirectory).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(parent.getShell());
                dd.setText(Msgs.selectLiferaySourceDirectory);
                dd.setFilterPath(sourceField.getText());
                String selectedFile = dd.open();
                if (selectedFile != null && new File(selectedFile).exists()) {
                    sourceField.setText(selectedFile);
                }
            }
        });
        return sourceField;
    }

    protected static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout(2, false);
        return layout;
    }

    protected void createSpacer() {
        new Label((Composite)this, 0);
    }

    protected static Text createTextField(Composite parent, String labelText) {
        LiferayTomcatRuntimeOptionalComposite.createLabel(parent, labelText);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected static String getJavadocDirectoryURL(String selectedFile) {
        Object[] files;
        String retval = null;
        Object javadocDirectory = new File(selectedFile);
        if (((File)javadocDirectory).exists() && ((File)javadocDirectory).isDirectory() && !CoreUtil.empty((Object[])(files = ((File)javadocDirectory).listFiles()))) {
            Object nestedFile;
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                nestedFile = objectArray[n2];
                if (((File)nestedFile).getName().equals("javadocs")) {
                    javadocDirectory = nestedFile;
                }
                ++n2;
            }
            objectArray = files;
            n = files.length;
            n2 = 0;
            while (n2 < n) {
                nestedFile = objectArray[n2];
                if (((File)nestedFile).getName().equals("javadocs-all")) {
                    javadocDirectory = nestedFile;
                }
                ++n2;
            }
            File liferayDir = new File((File)javadocDirectory, "com/liferay");
            if (liferayDir.exists()) {
                try {
                    retval = ((File)javadocDirectory).toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return retval;
    }

    protected static String getJavadocZipURL(String selectedFile) {
        String retval = null;
        try {
            String rootEntryName = null;
            ZipEntry javadocEntry = null;
            File javadocFile = new File(selectedFile);
            ZipFile zipFile = new ZipFile(javadocFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            ZipEntry rootEntry = zipEntries.nextElement();
            rootEntryName = new Path(rootEntry.getName()).segment(0);
            if (rootEntryName.endsWith("/")) {
                rootEntryName = rootEntryName.substring(0, rootEntryName.length() - 1);
            }
            ZipEntry entry = zipEntries.nextElement();
            while (entry != null && javadocEntry == null) {
                String entryName = entry.getName();
                if (entryName.startsWith(String.valueOf(rootEntryName) + "/javadocs")) {
                    ZipEntry allEntry = new ZipEntry(String.valueOf(rootEntryName) + "/javadocs-all");
                    javadocEntry = zipFile.getInputStream(allEntry) != null ? allEntry : entry;
                }
                entry = zipEntries.nextElement();
            }
            if (javadocEntry != null) {
                retval = "jar:" + javadocFile.toURI().toURL().toExternalForm() + "!/" + javadocEntry.getName();
            }
            zipFile.close();
        }
        catch (Exception exception) {}
        return retval;
    }

    protected IJavaRuntime getJavaRuntime() {
        return this.runtime;
    }

    protected ILiferayTomcatRuntime getLiferayTomcatRuntime() {
        return LiferayTomcatUtil.getLiferayTomcatRuntime((IRuntime)this.runtimeWC);
    }

    protected IRuntimeWorkingCopy getRuntime() {
        return this.runtimeWC;
    }

    protected void init() {
        if (this.getRuntime() == null) {
            return;
        }
        String javadocURL = this.getLiferayTomcatRuntime().getJavadocURL();
        LiferayTomcatRuntimeOptionalComposite.setFieldValue(this.javadocField, javadocURL != null ? javadocURL : "");
        IPath sourceLocation = this.getLiferayTomcatRuntime().getSourceLocation();
        LiferayTomcatRuntimeOptionalComposite.setFieldValue(this.sourceField, sourceLocation != null ? sourceLocation.toOSString() : "");
    }

    public void modifyText(ModifyEvent e) {
        if (this.ignoreModifyEvent) {
            this.ignoreModifyEvent = false;
            return;
        }
        if (e.getSource().equals(this.javadocField)) {
            String newJavadocURL = null;
            String javadocValue = this.javadocField.getText();
            try {
                URL javadocURL = new URL(javadocValue);
                if (javadocURL.getProtocol() != null && javadocURL.getProtocol().startsWith("http")) {
                    newJavadocURL = javadocValue;
                }
                if (newJavadocURL == null) {
                    File javadocFile = new File(javadocValue);
                    if (javadocFile.isFile()) {
                        newJavadocURL = javadocFile.toURI().toURL().toExternalForm();
                    } else if (!javadocFile.isDirectory()) {
                        newJavadocURL = javadocValue;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                newJavadocURL = javadocValue;
            }
            this.getLiferayTomcatRuntime().setJavadocURL(newJavadocURL);
        } else if (e.getSource().equals(this.sourceField)) {
            this.getLiferayTomcatRuntime().setSourceLocation((IPath)new Path(this.sourceField.getText()));
        }
        this.validate();
    }

    public void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (ITomcatRuntimeWorkingCopy)newRuntime.loadAdapter(ITomcatRuntimeWorkingCopy.class, null);
        }
        this.init();
        this.validate();
    }

    private static class Msgs
    extends NLS {
        public static String browseDirectory;
        public static String browseZip;
        public static String directoryNotValid;
        public static String fileNotValid;
        public static String liferayJavadocURL;
        public static String liferayRuntimeTomcatBundle;
        public static String liferaysourceLocation;
        public static String liferayTomcatRuntime;
        public static String selectLiferayJavadocDirectory;
        public static String selectLiferayJavadocZipFile;
        public static String selectLiferaySourceDirectory;
        public static String selectLiferaySourceZipFile;
        public static String specifyExtraSettings;

        static {
            Msgs.initializeMessages((String)LiferayTomcatRuntimeOptionalComposite.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

