/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.namespaces;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.namespaces.INamespaceMatcher;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.util.StringUtils;

public class NamespacesManager
extends AbstractRegistryManager {
    private static final String NAMESPACES_EXTENSION_POINT = "namespaces";
    private static final String ID_ATTR = "id";
    private static final String NAMESPACES_ELT = "namespaces";
    private static final String MATCHER_ELT = "matcher";
    private static final String CLASS_ATTR = "class";
    private static final String PREFIX_ATTR = "prefix";
    private static final NamespacesManager INSTANCE = new NamespacesManager();
    private Map<String, Namespaces> namespacesById;

    public static NamespacesManager getInstance() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.namespacesById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addNamespaces(this.namespacesById, cf);
        }
    }

    public Namespaces getNamespaces(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        if (this.namespacesById == null) {
            this.loadNamespaces();
        }
        return this.namespacesById.get(id);
    }

    private synchronized void loadNamespaces() {
        if (this.namespacesById != null) {
            return;
        }
        HashMap<String, Namespaces> namespacesById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor(this.getPluginId(), "namespaces");
            namespacesById = new HashMap(cf.length);
            this.addNamespaces(namespacesById, cf);
        } else {
            namespacesById = new HashMap<String, Namespaces>();
        }
        this.namespacesById = namespacesById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addNamespaces(Map<String, Namespaces> namespacesById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("namespaces".equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                Namespaces namespaces = new Namespaces();
                IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren(MATCHER_ELT);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cns = iConfigurationElementArray2[n4];
                    this.parseNamespacesDecl(namespaces, cns);
                    ++n4;
                }
                namespacesById.put(id, namespaces);
            }
            ++n2;
        }
    }

    private void parseNamespacesDecl(Namespaces namespaces, IConfigurationElement cns) {
        String prefix = cns.getAttribute(PREFIX_ATTR);
        try {
            INamespaceMatcher matcher = (INamespaceMatcher)cns.createExecutableExtension(CLASS_ATTR);
            namespaces.addMatcher(prefix, matcher);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error namespace matcher.", e);
        }
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    @Override
    protected String getExtensionPoint() {
        return "namespaces";
    }
}

