/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.internal.resource.ResourceQuerySpecification;
import org.eclipse.wst.xml.search.core.resource.IResourceQuerySpecification;
import org.eclipse.wst.xml.search.core.util.StringUtils;

public class ResourceQuerySpecificationManager
extends AbstractRegistryManager {
    private static final ResourceQuerySpecificationManager INSTANCE = new ResourceQuerySpecificationManager();
    private static final String RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT = "resourceQuerySpecifications";
    private Map<String, IResourceQuerySpecification> querySpecificationsById = null;

    public static ResourceQuerySpecificationManager getDefault() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addQuerySpecifications(this.querySpecificationsById, cf);
        }
    }

    public IResourceQuerySpecification getQuerySpecification(String querySpecificationId) {
        IResourceQuerySpecification querySpecification;
        if (StringUtils.isEmpty(querySpecificationId)) {
            return ResourceQuerySpecification.DEFAULT;
        }
        if (this.querySpecificationsById == null) {
            this.loadQuerySpecifications();
        }
        if ((querySpecification = this.querySpecificationsById.get(querySpecificationId)) == null) {
            querySpecification = ResourceQuerySpecification.DEFAULT;
            this.querySpecificationsById.put(querySpecificationId, querySpecification);
        }
        return querySpecification;
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationsById != null) {
            return;
        }
        HashMap<String, IResourceQuerySpecification> querySpecificationsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.core", RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationsById = new HashMap(cf.length);
            this.addQuerySpecifications(querySpecificationsById, cf);
        } else {
            querySpecificationsById = new HashMap<String, IResourceQuerySpecification>();
        }
        this.querySpecificationsById = querySpecificationsById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addQuerySpecifications(Map<String, IResourceQuerySpecification> querySpecificationsById, IConfigurationElement[] cf) {
        String id = null;
        IResourceQuerySpecification querySpecification = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            id = ce.getAttribute("id");
            try {
                querySpecification = ResourceQuerySpecification.newQuerySpecification(ce.createExecutableExtension("class"));
                querySpecificationsById.put(id, querySpecification);
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load querySpecification for id: " + id, t);
            }
            ++n2;
        }
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    @Override
    protected String getExtensionPoint() {
        return RESOURCE_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }
}

